/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MachineMemory;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.SystemNanoClock;

public class ConfiguringPageCacheFactory {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final PageCacheTracer pageCacheTracer;
    private final InternalLog log;
    private PageCache pageCache;
    private final JobScheduler scheduler;
    private final SystemNanoClock clock;
    private final MemoryPools memoryPools;
    private final Function<MuninnPageCache.Configuration, MuninnPageCache.Configuration> pageCacheConfigurator;

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer pageCacheTracer, InternalLog log, JobScheduler scheduler, SystemNanoClock clock, MemoryPools memoryPools) {
        this(fs, config, pageCacheTracer, log, scheduler, clock, memoryPools, c -> c);
    }

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer pageCacheTracer, InternalLog log, JobScheduler scheduler, SystemNanoClock clock, MemoryPools memoryPools, Function<MuninnPageCache.Configuration, MuninnPageCache.Configuration> pageCacheConfigurator) {
        this.fs = fs;
        this.config = config;
        this.pageCacheTracer = pageCacheTracer;
        this.log = log;
        this.scheduler = scheduler;
        this.clock = clock;
        this.memoryPools = memoryPools;
        this.pageCacheConfigurator = pageCacheConfigurator;
    }

    public synchronized PageCache getOrCreatePageCache() {
        if (this.pageCache == null) {
            this.pageCache = this.createPageCache();
        }
        return this.pageCache;
    }

    private PageCache createPageCache() {
        long pageCacheMaxMemory = this.getPageCacheMaxMemory(this.config);
        GlobalMemoryGroupTracker memoryPool = this.memoryPools.pool(MemoryGroup.PAGE_CACHE, pageCacheMaxMemory, false, null);
        MemoryTracker memoryTracker = memoryPool.getPoolMemoryTracker();
        PageSwapperFactory swapperFactory = ConfiguringPageCacheFactory.createAndConfigureSwapperFactory(this.fs, this.pageCacheTracer, memoryTracker, this.log);
        MemoryAllocator memoryAllocator = ConfiguringPageCacheFactory.buildMemoryAllocator(pageCacheMaxMemory, (Long)this.config.get(GraphDatabaseInternalSettings.page_cache_allocation_grab_size), memoryTracker);
        ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(this.config, memoryTracker);
        MuninnPageCache.Configuration configuration = MuninnPageCache.config((MemoryAllocator)memoryAllocator).memoryTracker(memoryTracker).bufferFactory((IOBufferFactory)bufferFactory).reservedPageBytes(24).preallocateStoreFiles(((Boolean)this.config.get(GraphDatabaseSettings.preallocate_store_files)).booleanValue()).clock(this.clock).pageCacheTracer(this.pageCacheTracer).closeAllocatorOnShutdown(((Boolean)this.config.get(GraphDatabaseInternalSettings.close_allocator_on_shutdown)).booleanValue());
        configuration = this.pageCacheConfigurator.apply(configuration);
        return new MuninnPageCache(swapperFactory, this.scheduler, configuration);
    }

    private static MemoryAllocator buildMemoryAllocator(long pageCacheMaxMemory, Long grabSize, MemoryTracker memoryTracker) {
        return MemoryAllocator.createAllocator((long)pageCacheMaxMemory, (Long)grabSize, (MemoryTracker)memoryTracker);
    }

    private long getPageCacheMaxMemory(Config config) {
        Long pageCacheMemorySetting = (Long)config.get(GraphDatabaseSettings.pagecache_memory);
        if (pageCacheMemorySetting == null) {
            long heuristic = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory(MachineMemory.DEFAULT);
            this.log.warn("The " + GraphDatabaseSettings.pagecache_memory.name() + " setting has not been configured. It is recommended that this setting is always explicitly configured, to ensure the system has a balanced configuration. Until then, a computed heuristic value of " + heuristic + " bytes will be used instead. Run `neo4j-admin memory-recommendation` for memory configuration suggestions.");
            pageCacheMemorySetting = heuristic;
        }
        return pageCacheMemorySetting;
    }

    public static long defaultHeuristicPageCacheMemory(MachineMemory machineMemory) {
        long maxHeapMemory;
        String defaultMemoryOverride = System.getProperty("dbms.pagecache.memory.default.override");
        if (defaultMemoryOverride != null) {
            return (Long)SettingValueParsers.BYTES.parse(defaultMemoryOverride);
        }
        double ratioOfFreeMem = 0.5;
        String defaultMemoryRatioOverride = System.getProperty("dbms.pagecache.memory.ratio.default.override");
        if (defaultMemoryRatioOverride != null) {
            ratioOfFreeMem = Double.parseDouble(defaultMemoryRatioOverride);
        }
        if (0L < (maxHeapMemory = machineMemory.getHeapMemoryUsage().getMax()) && maxHeapMemory < Long.MAX_VALUE) {
            try {
                long physicalMemory = machineMemory.getTotalPhysicalMemory();
                if (0L < physicalMemory && physicalMemory < Long.MAX_VALUE && maxHeapMemory < physicalMemory) {
                    long heuristic = (long)((double)(physicalMemory - maxHeapMemory) * ratioOfFreeMem);
                    long min = ByteUnit.mebiBytes((long)32L);
                    long max = Math.min(maxHeapMemory * 70L, ByteUnit.gibiBytes((long)20L));
                    return Math.min(max, Math.max(min, heuristic));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ByteUnit.gibiBytes((long)2L);
    }

    public void dumpConfiguration() {
        Long pageCacheMemoryBytes = (Long)this.config.get(GraphDatabaseSettings.pagecache_memory);
        String pageCacheMemory = pageCacheMemoryBytes != null ? ByteUnit.bytesToStringWithoutScientificNotation((long)pageCacheMemoryBytes) : "<not specified>";
        long totalPhysicalMemory = OsBeanUtil.getTotalPhysicalMemory();
        String totalPhysicalMem = totalPhysicalMemory == -1L ? "?" : ByteUnit.bytesToString((long)totalPhysicalMemory);
        String maxVmMem = ByteUnit.bytesToStringWithoutScientificNotation((long)Runtime.getRuntime().maxMemory());
        String msg = "Physical mem: " + totalPhysicalMem + " Heap size: " + maxVmMem + " Page cache: " + pageCacheMemory + ".";
        this.log.info(msg);
    }

    private static PageSwapperFactory createAndConfigureSwapperFactory(FileSystemAbstraction fs, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, InternalLog log) {
        if (!UnsafeUtil.unsafeByteBufferAccessAvailable()) {
            log.warn("Reflection access to java.nio.DirectByteBuffer is not available, using fallback mode. This could have negative impact on performance and memory usage. Consider adding --add-opens=java.base/java.nio=ALL-UNNAMED to VM options.");
        }
        return new SingleFilePageSwapperFactory(fs, pageCacheTracer, memoryTracker);
    }
}

