/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.index.schema.PartitionedTokenScan;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.kernel.impl.index.schema.TokenScan;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultTokenReadSession;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.LockingNodeUniqueIndexSeek;
import org.neo4j.kernel.impl.newapi.LockingRelationshipUniqueIndexSeek;
import org.neo4j.kernel.impl.newapi.NodeCursorScan;
import org.neo4j.kernel.impl.newapi.NodeLabelIndexCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedNodeCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedRelationshipCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedTokenIndexCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedValueIndexCursorSeek;
import org.neo4j.kernel.impl.newapi.RelationshipCursorScan;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.util.Preconditions;

abstract class Read
implements TxStateHolder,
org.neo4j.internal.kernel.api.Read,
SchemaRead,
Procedures,
Locks,
AssertOpen,
LockingNodeUniqueIndexSeek.UniqueNodeIndexSeeker<DefaultNodeValueIndexCursor>,
LockingRelationshipUniqueIndexSeek.UniqueRelationshipIndexSeeker<DefaultRelationshipValueIndexCursor>,
QueryContext {
    protected final StorageReader storageReader;
    protected final DefaultPooledCursors cursors;
    private final TokenRead tokenRead;
    private final StorageLocks storageLocks;
    final StoreCursors storageCursors;
    private final LockTracer lockTracer;

    Read(StorageReader storageReader, TokenRead tokenRead, DefaultPooledCursors cursors, StoreCursors storageCursors, StorageLocks storageLocks, LockTracer lockTracer) {
        this.storageReader = storageReader;
        this.tokenRead = tokenRead;
        this.cursors = cursors;
        this.storageCursors = storageCursors;
        this.storageLocks = storageLocks;
        this.lockTracer = lockTracer;
    }

    public final void nodeIndexSeek(QueryContext queryContext, IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        this.validateConstraints(constraints, indexSession);
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index seek can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.setRead(this);
        indexSession.reader.query((IndexProgressor.EntityValueClient)client, queryContext, this.getAccessMode(), constraints, query);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index seek can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    public final void relationshipIndexSeek(QueryContext queryContext, IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        this.validateConstraints(constraints, indexSession);
        if (indexSession.reference.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index seek can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.setRead(this);
        indexSession.reader.query((IndexProgressor.EntityValueClient)client, queryContext, this.getAccessMode(), constraints, query);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index seek can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    public org.neo4j.internal.kernel.api.Read getRead() {
        return this;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public ReadableTransactionState getTransactionStateOrNull() {
        return this.hasTxStateWithChanges() ? this.txState() : null;
    }

    public long lockingNodeUniqueIndexSeek(IndexDescriptor index, NodeValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(index);
        Read.assertPredicatesMatchSchema(index, predicates);
        return LockingNodeUniqueIndexSeek.apply(this.getLockClient(), this.lockTracer, (DefaultNodeValueIndexCursor)cursor, this, this, index, predicates);
    }

    public long lockingRelationshipUniqueIndexSeek(IndexDescriptor index, RelationshipValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws KernelException {
        this.assertIndexOnline(index);
        Read.assertPredicatesMatchSchema(index, predicates);
        return LockingRelationshipUniqueIndexSeek.apply(this.getLockClient(), this.lockTracer, (DefaultRelationshipValueIndexCursor)cursor, this, this, index, predicates);
    }

    @Override
    public void nodeIndexSeekWithFreshIndexReader(DefaultNodeValueIndexCursor cursor, ValueIndexReader indexReader, PropertyIndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.setRead(this);
        indexReader.query((IndexProgressor.EntityValueClient)cursor, (QueryContext)this, this.getAccessMode(), IndexQueryConstraints.unconstrained(), (PropertyIndexQuery[])query);
    }

    @Override
    public void relationshipIndexSeekWithFreshIndexReader(DefaultRelationshipValueIndexCursor cursor, ValueIndexReader indexReader, PropertyIndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.setRead(this);
        indexReader.query((IndexProgressor.EntityValueClient)cursor, (QueryContext)this, this.getAccessMode(), IndexQueryConstraints.unconstrained(), (PropertyIndexQuery[])query);
    }

    public final void nodeIndexScan(IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index scan can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index scan can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    public final void relationshipIndexScan(IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index scan can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index scan can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.propertyIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    private void scanIndex(DefaultIndexReadSession indexSession, EntityIndexSeekClient indexSeekClient, IndexQueryConstraints constraints) throws KernelException {
        indexSeekClient.setRead(this);
        indexSession.reader.query((IndexProgressor.EntityValueClient)indexSeekClient, (QueryContext)this, this.getAccessMode(), constraints, new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
    }

    public final Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        TokenScan tokenScan;
        this.performCheckBeforeOperation();
        try {
            IndexDescriptor index = this.index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE), IndexType.LOOKUP);
            if (index == IndexDescriptor.NO_INDEX) {
                throw new IndexNotFoundKernelException("There is no index that can back a node label scan.");
            }
            DefaultTokenReadSession session = (DefaultTokenReadSession)this.tokenReadSession(index);
            tokenScan = session.reader.entityTokenScan(label, this.cursorContext());
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
        return new NodeLabelIndexCursorScan(this, label, tokenScan);
    }

    public final PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public final PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, PartitionedScan<NodeLabelIndexCursor> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, leadingPartitionScan, query);
    }

    public final List<PartitionedScan<NodeLabelIndexCursor>> nodeLabelScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public final void nodeLabelScan(TokenReadSession session, NodeLabelIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this);
        tokenSession.reader.query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, cursorContext);
    }

    public final void allNodesScan(NodeCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultNodeCursor)cursor).scan(this);
    }

    public final Scan<NodeCursor> allNodesScan() {
        this.performCheckBeforeOperation();
        return new NodeCursorScan(this.storageReader.allNodeScan(), this);
    }

    public final void singleNode(long reference, NodeCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultNodeCursor)cursor).single(reference, this);
    }

    public PartitionedScan<NodeCursor> allNodesScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        this.performCheckBeforeOperation();
        long totalCount = this.storageReader.nodesGetCount(cursorContext);
        return new PartitionedNodeCursorScan(this.storageReader.allNodeScan(), this, desiredNumberOfPartitions, totalCount);
    }

    public PartitionedScan<RelationshipScanCursor> allRelationshipsScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        this.performCheckBeforeOperation();
        long totalCount = this.storageReader.relationshipsGetCount(cursorContext);
        return new PartitionedRelationshipCursorScan(this.storageReader.allRelationshipScan(), this, desiredNumberOfPartitions, totalCount);
    }

    public final void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).single(reference, this);
    }

    public void singleRelationship(long reference, long sourceNodeReference, int type, long targetNodeReference, RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).single(reference, sourceNodeReference, type, targetNodeReference, this);
    }

    public final void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).scan(this);
    }

    public final Scan<RelationshipScanCursor> allRelationshipsScan() {
        this.performCheckBeforeOperation();
        return new RelationshipCursorScan(this.storageReader.allRelationshipScan(), this);
    }

    public final PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public final PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, PartitionedScan<RelationshipTypeIndexCursor> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, leadingPartitionScan, query);
    }

    public final List<PartitionedScan<RelationshipTypeIndexCursor>> relationshipTypeScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public final void relationshipTypeScan(TokenReadSession session, RelationshipTypeIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        DefaultRelationshipTypeIndexCursor indexCursor = (DefaultRelationshipTypeIndexCursor)cursor;
        indexCursor.setRead(this);
        tokenSession.reader.query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, cursorContext);
    }

    public void relationships(long nodeReference, long reference, RelationshipSelection selection, RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, reference, selection, this);
    }

    public void nodeProperties(long nodeReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(nodeReference, reference, selection, this);
    }

    public void relationshipProperties(long relationshipReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initRelationship(relationshipReference, reference, selection, this);
    }

    private void validateConstraints(IndexQueryConstraints constraints, DefaultIndexReadSession indexSession) {
        if (constraints.needsValues() && !indexSession.reference().getCapability().supportsReturningValues()) {
            throw new UnsupportedOperationException(String.format("%s index has no value capability", indexSession.reference().getIndexType()));
        }
    }

    private <C extends Cursor> PartitionedScan<C> propertyIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
    }

    private <C extends Cursor> PartitionedScan<C> propertyIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (!descriptor.getCapability().supportPartitionedScan((IndexQuery[])query)) {
            throw new IndexNotApplicableKernelException("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        DefaultIndexReadSession session = (DefaultIndexReadSession)index;
        PartitionedValueSeek valueSeek = session.reader.valueSeek(desiredNumberOfPartitions, queryContext, query);
        return new PartitionedValueIndexCursorSeek(this, descriptor, valueSeek, query);
    }

    private <C extends Cursor> PartitionedScan<C> tokenIndexScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = session.reference();
        if (!descriptor.getCapability().supportPartitionedScan(new IndexQuery[]{query})) {
            throw new IndexNotApplicableKernelException("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        DefaultTokenReadSession defaultSession = (DefaultTokenReadSession)session;
        PartitionedTokenScan tokenScan = defaultSession.reader.entityTokenScan(desiredNumberOfPartitions, cursorContext, query);
        return new PartitionedTokenIndexCursorScan(this, query, tokenScan);
    }

    private <C extends Cursor> PartitionedScan<C> tokenIndexScan(TokenReadSession session, PartitionedScan<C> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = session.reference();
        if (!descriptor.getCapability().supportPartitionedScan(new IndexQuery[]{query})) {
            throw new IndexNotApplicableKernelException("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead));
        }
        DefaultTokenReadSession defaultSession = (DefaultTokenReadSession)session;
        PartitionedTokenIndexCursorScan leadingTokenIndexCursorScan = (PartitionedTokenIndexCursorScan)leadingPartitionScan;
        PartitionedTokenScan tokenScan = defaultSession.reader.entityTokenScan(leadingTokenIndexCursorScan.getTokenScan(), query);
        return new PartitionedTokenIndexCursorScan(this, query, tokenScan);
    }

    private <C extends Cursor> List<PartitionedScan<C>> tokenIndexScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        Preconditions.requireNonEmpty((Object[])queries);
        ArrayList<PartitionedScan<C>> scans = new ArrayList<PartitionedScan<C>>(queries.length);
        PartitionedScan<C> leadingPartitionScan = this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries[0]);
        scans.add(leadingPartitionScan);
        for (int i = 1; i < queries.length; ++i) {
            scans.add(this.tokenIndexScan(session, leadingPartitionScan, queries[i]));
        }
        return scans;
    }

    public abstract ValueIndexReader newValueIndexReader(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public void acquireExclusiveNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireExclusiveNodeLock(this.lockTracer, ids);
    }

    public void acquireExclusiveRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireExclusiveRelationshipLock(this.lockTracer, ids);
    }

    public void releaseExclusiveNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseExclusiveNodeLock(ids);
    }

    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseExclusiveRelationshipLock(ids);
    }

    public void acquireSharedNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireSharedNodeLock(this.lockTracer, ids);
    }

    public void acquireSharedRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.acquireSharedRelationshipLock(this.lockTracer, ids);
    }

    public void acquireSharedRelationshipTypeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.acquireSharedLock(ResourceType.RELATIONSHIP_TYPE, ids);
    }

    public void acquireSharedLabelLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.acquireSharedLock(ResourceType.LABEL, ids);
    }

    public void releaseSharedNodeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseSharedNodeLock(ids);
    }

    public void releaseSharedRelationshipLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.storageLocks.releaseSharedRelationshipLock(ids);
    }

    public void releaseSharedLabelLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.releaseSharedLock(ResourceType.LABEL, ids);
    }

    public void releaseSharedRelationshipTypeLock(long ... ids) {
        this.performCheckBeforeOperation();
        this.releaseSharedLock(ResourceType.RELATIONSHIP_TYPE, ids);
    }

    <T extends SchemaDescriptorSupplier> T acquireSharedSchemaLock(T schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        long[] lockingKeys = schema.lockingKeys();
        this.getLockClient().acquireShared(this.lockTracer, schema.keyType(), lockingKeys);
        return schemaLike;
    }

    <T extends SchemaDescriptorSupplier> void releaseSharedSchemaLock(T schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        long[] lockingKeys = schema.lockingKeys();
        this.getLockClient().releaseShared(schema.keyType(), lockingKeys);
    }

    void acquireSharedLock(ResourceType resource, long resourceId) {
        this.getLockClient().acquireShared(this.lockTracer, resource, new long[]{resourceId});
    }

    private void acquireSharedLock(ResourceType type, long ... ids) {
        this.getLockClient().acquireShared(this.lockTracer, type, ids);
    }

    private void releaseSharedLock(ResourceType types, long ... ids) {
        this.getLockClient().releaseShared(types, ids);
    }

    private void assertIndexOnline(IndexDescriptor index) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.indexGetState(index) == InternalIndexState.ONLINE) {
            return;
        }
        throw new IndexBrokenKernelException(this.indexGetFailure(index));
    }

    private static void assertPredicatesMatchSchema(IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = index.schema().getPropertyIds();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }

    public void assertOpen() {
        this.performCheckBeforeOperation();
    }

    public void acquireSharedLookupLock(EntityType entityType) {
        this.acquireSharedSchemaLock(() -> SchemaDescriptors.forAnyEntityTokens((EntityType)entityType));
        this.performCheckBeforeOperation();
    }

    public void releaseSharedLookupLock(EntityType entityType) {
        this.releaseSharedSchemaLock(() -> SchemaDescriptors.forAnyEntityTokens((EntityType)entityType));
        this.performCheckBeforeOperation();
    }

    abstract void performCheckBeforeOperation();

    abstract AccessMode getAccessMode();

    abstract LockManager.Client getLockClient();
}

