/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;

public class DefaultRelationshipBasedRelationshipTypeIndexCursor
extends DefaultRelationshipTypeIndexCursor
implements RelationshipTypeIndexCursor {
    private final DefaultRelationshipScanCursor relationshipScanCursor;

    DefaultRelationshipBasedRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool, DefaultRelationshipScanCursor relationshipScanCursor) {
        super(pool);
        this.relationshipScanCursor = relationshipScanCursor;
    }

    public long sourceNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.targetNodeReference();
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        this.checkReadFromStore();
        this.relationshipScanCursor.properties(cursor, selection);
    }

    public Reference propertiesReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.propertiesReference();
    }

    public boolean readFromStore() {
        if (this.relationshipScanCursor.relationshipReference() == this.entity) {
            return true;
        }
        this.relationshipScanCursor.single(this.entity, this.read);
        return this.relationshipScanCursor.next();
    }

    @Override
    public void release() {
        this.relationshipScanCursor.close();
        this.relationshipScanCursor.release();
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTypeIndexCursor[closed state, relationship based]";
        }
        return "RelationshipTypeIndexCursor[relationship=" + this.relationshipReference() + ", relationship based]";
    }

    @Override
    protected boolean allowedToSeeEntity(AccessMode accessMode, long entityReference) {
        if (accessMode.allowsTraverseAllRelTypes()) {
            return true;
        }
        this.read.singleRelationship(entityReference, this.relationshipScanCursor);
        return this.relationshipScanCursor.next();
    }

    @Override
    protected boolean innerNext() {
        return this.indexNext();
    }

    @Override
    protected LongIterator createAddedInTxState(TransactionState txState, int token, IndexOrder order) {
        return DefaultRelationshipBasedRelationshipTypeIndexCursor.sortTxState(txState.relationshipsWithTypeChanged(token).getAdded().freeze(), order);
    }

    @Override
    protected LongSet createDeletedInTxState(TransactionState txState, int token) {
        return txState.addedAndRemovedRelationships().getRemoved().freeze();
    }

    private void checkReadFromStore() {
        if (this.relationshipScanCursor.relationshipReference() != this.entity) {
            throw new IllegalStateException("Relationship hasn't been read from store");
        }
    }
}

