/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.IndexImporter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class TokenIndexImporter
implements IndexImporter {
    private static final String INDEX_TOKEN_IMPORTER_TAG = "indexTokenImporter";
    private final IndexDescriptor index;
    private final PageCacheTracer pageCacheTracer;
    private final TokenIndexAccessor accessor;
    private final CursorContext cursorContext;

    TokenIndexImporter(IndexDescriptor index, DatabaseLayout layout, FileSystemAbstraction fs, PageCache cache, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        this.index = index;
        this.pageCacheTracer = pageCacheTracer;
        this.accessor = this.tokenIndexAccessor(layout, fs, cache, contextFactory, pageCacheTracer, openOptions, indexingBehaviour);
        this.cursorContext = contextFactory.create(INDEX_TOKEN_IMPORTER_TAG);
    }

    public IndexImporter.Writer writer(boolean parallel) {
        final IndexUpdater actual = this.accessor.newUpdater(IndexUpdateMode.ONLINE, this.cursorContext, parallel);
        return new IndexImporter.Writer(){

            public void add(long entity, long[] tokens) {
                try {
                    actual.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entity, (SchemaDescriptorSupplier)TokenIndexImporter.this.index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])tokens, (boolean)true));
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
            }

            public void remove(long entity, long[] tokens) {
                try {
                    actual.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entity, (SchemaDescriptorSupplier)TokenIndexImporter.this.index, (long[])tokens, (long[])ArrayUtils.EMPTY_LONG_ARRAY));
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
            }

            public void close() throws IOException {
                try {
                    actual.close();
                }
                catch (IndexEntryConflictException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public void close() throws IOException {
        Closeable flush = () -> {
            try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
                this.accessor.force(flushEvent, this.cursorContext);
            }
        };
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{flush, this.accessor});
    }

    private TokenIndexAccessor tokenIndexAccessor(DatabaseLayout layout, FileSystemAbstraction fs, PageCache pageCache, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        DatabaseIndexContext context = DatabaseIndexContext.builder(pageCache, fs, contextFactory, pageCacheTracer, layout.getDatabaseName()).build();
        IndexDirectoryStructure indexDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)layout.databaseDirectory()).forProvider(TokenIndexProvider.DESCRIPTOR);
        IndexFiles indexFiles = TokenIndexProvider.indexFiles((SchemaRule)this.index, fs, indexDirectoryStructure);
        return new TokenIndexAccessor(context, indexFiles, this.index, RecoveryCleanupWorkCollector.immediate(), openOptions, false, indexingBehaviour);
    }
}

