/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntryStreamMerger;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobHandles;

class PartMerger<KEY, VALUE>
implements AutoCloseable {
    static final int DEFAULT_BATCH_SIZE = 100;
    private static final int MERGE_FACTOR = 4;
    private final IndexPopulator.PopulationWorkScheduler populationWorkScheduler;
    private final List<BlockEntryCursor<KEY, VALUE>> parts;
    private final Layout<KEY, VALUE> layout;
    private final BlockStorage.Cancellation cancellation;
    private final int batchSize;
    private final Comparator<KEY> samplingComparator;
    private final List<BlockEntryStreamMerger<KEY, VALUE>> allMergers = new ArrayList<BlockEntryStreamMerger<KEY, VALUE>>();
    private final List<JobHandle<Void>> mergeHandles = new ArrayList<JobHandle<Void>>();

    PartMerger(IndexPopulator.PopulationWorkScheduler populationWorkScheduler, List<BlockEntryCursor<KEY, VALUE>> parts, Layout<KEY, VALUE> layout, Comparator<KEY> samplingComparator, BlockStorage.Cancellation cancellation, int batchSize) {
        this.populationWorkScheduler = populationWorkScheduler;
        this.parts = parts;
        this.layout = layout;
        this.cancellation = cancellation;
        this.batchSize = batchSize;
        this.samplingComparator = samplingComparator;
    }

    BlockEntryStreamMerger<KEY, VALUE> startMerge() {
        ArrayList<BlockEntryCursor<KEY, VALUE>> remainingParts = new ArrayList<BlockEntryCursor<KEY, VALUE>>(this.parts);
        while (remainingParts.size() > 4) {
            ArrayList current = new ArrayList();
            ArrayList levelParts = new ArrayList();
            for (BlockEntryCursor blockEntryCursor : remainingParts) {
                current.add(blockEntryCursor);
                if (current.size() != 4) continue;
                BlockEntryStreamMerger merger = new BlockEntryStreamMerger(current, this.layout, null, this.cancellation, this.batchSize, 10);
                this.allMergers.add(merger);
                levelParts.add(merger);
                current = new ArrayList();
            }
            levelParts.addAll(current);
            remainingParts = levelParts;
        }
        BlockEntryStreamMerger<KEY, VALUE> merger = new BlockEntryStreamMerger<KEY, VALUE>(remainingParts, this.layout, this.samplingComparator, this.cancellation, this.batchSize, 10);
        this.allMergers.add(merger);
        this.allMergers.forEach(merge -> this.mergeHandles.add((JobHandle<Void>)this.populationWorkScheduler.schedule(indexName -> "Part merger while writing scan update for " + indexName, (Callable)merge)));
        return merger;
    }

    @Override
    public void close() throws IOException {
        this.allMergers.forEach(BlockEntryStreamMerger::halt);
        try {
            JobHandles.getAllResults(this.mergeHandles);
        }
        catch (ExecutionException e) {
            try {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            catch (Throwable throwable) {
                IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{() -> IOUtils.closeAll(this.allMergers), () -> IOUtils.closeAll(this.parts)});
                throw throwable;
            }
        }
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{() -> IOUtils.closeAll(this.allMergers), () -> IOUtils.closeAll(this.parts)});
    }
}

