/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteOrder;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.memory.MemoryTracker;

public class ReadAheadLogChannel
extends ReadAheadChannel<LogVersionedStoreChannel>
implements ReadableLogChannel {
    private final LogVersionBridge bridge;
    private final boolean raw;

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, MemoryTracker memoryTracker) {
        this(startingChannel, LogVersionBridge.NO_MORE_CHANNELS, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, ByteOrder.LITTLE_ENDIAN, memoryTracker), false);
    }

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, MemoryTracker memoryTracker) {
        this(startingChannel, bridge, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, ByteOrder.LITTLE_ENDIAN, memoryTracker), false);
    }

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, MemoryTracker memoryTracker, boolean raw) {
        this(startingChannel, bridge, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, ByteOrder.LITTLE_ENDIAN, memoryTracker), raw);
    }

    private ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, ScopedBuffer scopedBuffer, boolean raw) {
        super((StoreChannel)startingChannel, scopedBuffer);
        this.bridge = bridge;
        this.raw = raw;
    }

    public long getLogVersion() {
        return ((LogVersionedStoreChannel)this.channel).getLogVersion();
    }

    public byte getLogFormatVersion() {
        return ((LogVersionedStoreChannel)this.channel).getLogFormatVersion();
    }

    public byte markAndGetVersion(LogPositionMarker marker) throws IOException {
        LogPositionMarker currentMarker = this.getCurrentLogPosition(marker);
        byte data = this.getVersion();
        if (!currentMarker.isMarkerInLog(((LogVersionedStoreChannel)this.channel).getLogVersion())) {
            marker.mark(((LogVersionedStoreChannel)this.channel).getLogVersion(), this.position() - 1L);
        }
        return data;
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(((LogVersionedStoreChannel)this.channel).getLogVersion(), this.position());
        return positionMarker;
    }

    public LogPosition getCurrentLogPosition() throws IOException {
        return new LogPosition(((LogVersionedStoreChannel)this.channel).getLogVersion(), this.position());
    }

    protected LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
        return this.bridge.next(channel, this.raw);
    }

    public void close() throws IOException {
        super.close();
    }
}

