/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.values.virtual.MapValue;

public class Neo4jTransactionalContextFactory
implements TransactionalContextFactory {
    private final Neo4jTransactionalContext.Creator contextCreator;

    public static TransactionalContextFactory create(Supplier<GraphDatabaseQueryService> queryServiceSupplier, KernelTransactionFactory transactionFactory) {
        Suppliers.Lazy queryService = Suppliers.lazySingleton(queryServiceSupplier);
        Neo4jTransactionalContext.Creator contextCreator = (arg_0, arg_1, arg_2, arg_3) -> Neo4jTransactionalContextFactory.lambda$create$0((Supplier)queryService, transactionFactory, arg_0, arg_1, arg_2, arg_3);
        return new Neo4jTransactionalContextFactory(contextCreator);
    }

    @Deprecated
    public static TransactionalContextFactory create(GraphDatabaseQueryService queryService) {
        DependencyResolver resolver = queryService.getDependencyResolver();
        KernelTransactionFactory transactionFactory = (KernelTransactionFactory)resolver.resolveDependency(KernelTransactionFactory.class);
        Neo4jTransactionalContext.Creator contextCreator = (tx, initialStatement, executingQuery, queryExecutionConfiguration) -> new Neo4jTransactionalContext(queryService, tx, initialStatement, executingQuery, transactionFactory, queryExecutionConfiguration);
        return new Neo4jTransactionalContextFactory(contextCreator);
    }

    private Neo4jTransactionalContextFactory(Neo4jTransactionalContext.Creator contextCreator) {
        this.contextCreator = contextCreator;
    }

    @Override
    public TransactionalContext newContext(InternalTransaction tx, String queryText, ExecutingQuery parentQuery, MapValue queryParameters, QueryExecutionConfiguration queryExecutionConfiguration) {
        return this.newContext(tx, queryText, queryParameters, queryExecutionConfiguration);
    }

    @Override
    public final Neo4jTransactionalContext newContext(InternalTransaction tx, String queryText, MapValue queryParameters, QueryExecutionConfiguration queryExecutionConfiguration) {
        KernelStatement initialStatement = (KernelStatement)tx.kernelTransaction().acquireStatement();
        ExecutingQuery executingQuery = initialStatement.queryRegistry().startAndBindExecutingQuery(queryText, queryParameters);
        return this.contextCreator.create(tx, initialStatement, executingQuery, queryExecutionConfiguration);
    }

    @Override
    public TransactionalContext newContextForQuery(InternalTransaction tx, ExecutingQuery executingQuery, QueryExecutionConfiguration queryExecutionConfiguration) {
        KernelStatement initialStatement = (KernelStatement)tx.kernelTransaction().acquireStatement();
        initialStatement.queryRegistry().bindExecutingQuery(executingQuery);
        return this.contextCreator.create(tx, initialStatement, executingQuery, queryExecutionConfiguration);
    }

    private static /* synthetic */ Neo4jTransactionalContext lambda$create$0(Supplier queryService, KernelTransactionFactory transactionFactory, InternalTransaction tx, KernelStatement initialStatement, ExecutingQuery executingQuery, QueryExecutionConfiguration queryExecutionConfiguration) {
        return new Neo4jTransactionalContext((GraphDatabaseQueryService)queryService.get(), tx, initialStatement, executingQuery, transactionFactory, queryExecutionConfiguration);
    }
}

