/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.CloseableResourceManager;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextCursorTracer;
import org.neo4j.kernel.impl.api.parallel.ExtendedAssertOpen;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.ElementIdMapper;

public class ThreadExecutionContext
implements ExecutionContext,
AutoCloseable {
    private final CloseableResourceManager resourceManager = new CloseableResourceManager();
    private final DefaultPooledCursors cursors;
    private final CursorContext context;
    private final OverridableSecurityContext overridableSecurityContext;
    private final ExecutionContextCursorTracer cursorTracer;
    private final CursorContext ktxContext;
    private final AllStoreHolder.ForThreadExecutionContextScope allStoreHolder;
    private final TokenRead tokenRead;
    private final StoreCursors storageCursors;
    private final IndexMonitor monitor;
    private final MemoryTracker contextTracker;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final ElementIdMapper elementIdMapper;
    private final List<AutoCloseable> otherResources;
    private final ExtendedAssertOpen assertOpen;

    public ThreadExecutionContext(DefaultPooledCursors cursors, CursorContext context, OverridableSecurityContext overridableSecurityContext, ExecutionContextCursorTracer cursorTracer, CursorContext ktxContext, TokenRead tokenRead, StoreCursors storageCursors, IndexMonitor monitor, MemoryTracker contextTracker, SecurityAuthorizationHandler securityAuthorizationHandler, StorageReader storageReader, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, GlobalProcedures globalProcedures, Dependencies databaseDependencies, StorageLocks storageLocks, Locks.Client lockClient, LockTracer lockTracer, ElementIdMapper elementIdMapper, ExtendedAssertOpen assertOpen, Supplier<ClockContext> clockContextSupplier, List<AutoCloseable> otherResources, boolean enableIndexUsageStatistics) {
        this.cursors = cursors;
        this.context = context;
        this.overridableSecurityContext = overridableSecurityContext;
        this.cursorTracer = cursorTracer;
        this.ktxContext = ktxContext;
        this.tokenRead = tokenRead;
        this.storageCursors = storageCursors;
        this.monitor = monitor;
        this.contextTracker = contextTracker;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
        this.otherResources = otherResources;
        this.elementIdMapper = elementIdMapper;
        this.assertOpen = assertOpen;
        this.allStoreHolder = new AllStoreHolder.ForThreadExecutionContextScope(this, storageReader, schemaState, indexingService, indexStatisticsStore, globalProcedures, databaseDependencies, cursors, storageCursors, context, storageLocks, lockClient, lockTracer, overridableSecurityContext, assertOpen, securityAuthorizationHandler, clockContextSupplier, enableIndexUsageStatistics);
    }

    public CursorContext cursorContext() {
        return this.context;
    }

    public DefaultPooledCursors cursors() {
        return this.cursors;
    }

    public SecurityContext securityContext() {
        return this.overridableSecurityContext.currentSecurityContext();
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public TokenRead tokenRead() {
        return this.tokenRead;
    }

    public SchemaRead schemaRead() {
        return this.allStoreHolder;
    }

    public Procedures procedures() {
        return this.allStoreHolder;
    }

    public void complete() {
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>(this.otherResources);
        resources.add(this.resourceManager::closeAllCloseableResources);
        resources.add(this.cursors::release);
        resources.add((AutoCloseable)this.storageCursors);
        IOUtils.closeAllUnchecked(resources);
        this.cursorTracer.complete();
    }

    public void report() {
        this.mergeBlocked(this.cursorTracer);
    }

    public ElementIdMapper elementIdMapper() {
        return this.elementIdMapper;
    }

    public void performCheckBeforeOperation() {
        this.assertOpen.assertOpen();
    }

    public boolean isTransactionOpen() {
        return this.assertOpen.isOpen();
    }

    public QueryContext queryContext() {
        return this.allStoreHolder;
    }

    public MemoryTracker memoryTracker() {
        return this.contextTracker;
    }

    public Locks locks() {
        return this.allStoreHolder;
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.securityAuthorizationHandler;
    }

    IndexMonitor monitor() {
        return this.monitor;
    }

    @Override
    public void close() {
        if (!this.cursorTracer.isCompleted()) {
            throw new IllegalStateException("Execution context closed before it was marked as completed.");
        }
        this.mergeUnblocked(this.cursorTracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeBlocked(ExecutionContextCursorTracer cursorTracer) {
        CursorContext cursorContext = this.ktxContext;
        synchronized (cursorContext) {
            this.mergeUnblocked(cursorTracer);
        }
        VarHandle.fullFence();
    }

    private void mergeUnblocked(ExecutionContextCursorTracer cursorTracer) {
        this.ktxContext.merge(cursorTracer.snapshot());
    }

    public void registerCloseableResource(AutoCloseable closeableResource) {
        this.resourceManager.registerCloseableResource(closeableResource);
    }

    public void unregisterCloseableResource(AutoCloseable closeableResource) {
        this.resourceManager.unregisterCloseableResource(closeableResource);
    }
}

