/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.api.chunk.ChunkedTransactionSink;
import org.neo4j.kernel.impl.api.commit.TransactionCommitter;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.memory.MemoryTracker;

public final class ChunkSink
implements ChunkedTransactionSink {
    private final TransactionClockContext clocks;
    private final long chunkSize;
    private final TransactionCommitter committer;
    private CursorContext cursorContext;
    private LeaseClient leaseClient;
    private long startTimeMillis;
    private long lastTransactionIdWhenStarted;

    public ChunkSink(TransactionCommitter committer, TransactionClockContext clocks, Config config) {
        this.clocks = clocks;
        this.chunkSize = (Long)config.get(GraphDatabaseInternalSettings.multi_version_transaction_chunk_size);
        this.committer = committer;
    }

    @Override
    public void write(TxState txState, TransactionEvent transactionEvent) {
        MemoryTracker memoryTracker = txState.memoryTracker();
        if (memoryTracker.estimatedHeapMemory() > this.chunkSize) {
            try (TransactionWriteEvent chunkWriteEvent = transactionEvent.beginChunkWriteEvent();){
                this.committer.commit(chunkWriteEvent, this.leaseClient, this.cursorContext, memoryTracker, KernelTransaction.NO_MONITOR, this.clocks.systemClock().millis(), this.startTimeMillis, this.lastTransactionIdWhenStarted, false);
                txState.reset();
            }
            catch (KernelException ke) {
                throw new RuntimeException("Fail to append transaction chunk.", ke);
            }
        }
    }

    @Override
    public void initialize(LeaseClient leaseClient, CursorContext cursorContext, long startTimeMillis, long lastTransactionIdWhenStarted) {
        this.cursorContext = cursorContext;
        this.leaseClient = leaseClient;
        this.startTimeMillis = startTimeMillis;
        this.lastTransactionIdWhenStarted = lastTransactionIdWhenStarted;
    }
}

