/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Objects;
import org.neo4j.kernel.api.KernelTransaction;

public class KernelTransactionStamp {
    private final KernelTransaction ktx;
    private final long transactionSequenceNumber;

    public KernelTransactionStamp(KernelTransaction ktx) {
        this.transactionSequenceNumber = ktx.getTransactionSequenceNumber();
        this.ktx = ktx;
    }

    public boolean isOpen() {
        return this.ktx.isOpen() && this.transactionSequenceNumber == this.ktx.getTransactionSequenceNumber();
    }

    public boolean isClosing() {
        return this.ktx.isClosing() && this.transactionSequenceNumber == this.ktx.getTransactionSequenceNumber();
    }

    long getTransactionSequenceNumber() {
        return this.transactionSequenceNumber;
    }

    public boolean isNotExpired() {
        return this.transactionSequenceNumber == this.ktx.getTransactionSequenceNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KernelTransactionStamp that = (KernelTransactionStamp)o;
        return this.transactionSequenceNumber == that.transactionSequenceNumber && Objects.equals(this.ktx, that.ktx);
    }

    public int hashCode() {
        int result = this.ktx != null ? this.ktx.hashCode() : 0;
        result = 31 * result + (int)(this.transactionSequenceNumber ^ this.transactionSequenceNumber >>> 32);
        return result;
    }
}

