/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.procedure;

import java.time.Clock;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.ValueMapper;

public class BasicContext
implements Context {
    private final DependencyResolver resolver;
    private final Transaction procedureTransaction;
    private final InternalTransaction internalTransaction;
    private final SecurityContext securityContext;
    private final ClockContext clockContext;
    private final ValueMapper<Object> valueMapper;
    private final Thread thread;
    private final ProcedureCallContext procedureCallContext;

    private BasicContext(DependencyResolver resolver, Transaction procedureTransaction, InternalTransaction internalTransaction, SecurityContext securityContext, ClockContext clockContext, ValueMapper<Object> valueMapper, Thread thread, ProcedureCallContext procedureCallContext) {
        this.resolver = resolver;
        this.procedureTransaction = procedureTransaction;
        this.internalTransaction = internalTransaction;
        this.securityContext = securityContext;
        this.clockContext = clockContext;
        this.valueMapper = valueMapper;
        this.thread = thread;
        this.procedureCallContext = procedureCallContext;
    }

    @Override
    public ValueMapper<Object> valueMapper() {
        return this.valueMapper;
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public DependencyResolver dependencyResolver() {
        return this.resolver;
    }

    @Override
    public GraphDatabaseAPI graphDatabaseAPI() {
        return (GraphDatabaseAPI)this.resolver.resolveDependency(GraphDatabaseAPI.class);
    }

    @Override
    public Thread thread() {
        return this.thread;
    }

    @Override
    public Transaction transaction() throws ProcedureException {
        return (Transaction)BasicContext.throwIfNull("Transaction", this.procedureTransaction);
    }

    @Override
    public InternalTransaction internalTransaction() throws ProcedureException {
        return (InternalTransaction)BasicContext.throwIfNull("Transaction", this.internalTransaction);
    }

    @Override
    public InternalTransaction internalTransactionOrNull() {
        return this.internalTransaction;
    }

    @Override
    public Clock systemClock() throws ProcedureException {
        return BasicContext.throwIfNull("SystemClock", this.clockContext, ClockContext::systemClock);
    }

    @Override
    public Clock statementClock() throws ProcedureException {
        return BasicContext.throwIfNull("StatementClock", this.clockContext, ClockContext::statementClock);
    }

    @Override
    public Clock transactionClock() throws ProcedureException {
        return BasicContext.throwIfNull("TransactionClock", this.clockContext, ClockContext::transactionClock);
    }

    @Override
    public ProcedureCallContext procedureCallContext() {
        return this.procedureCallContext;
    }

    public static ContextBuilder buildContext(DependencyResolver dependencyResolver, ValueMapper<Object> valueMapper) {
        return new ContextBuilder(dependencyResolver, valueMapper);
    }

    private static <T, U> T throwIfNull(String name, U value) throws ProcedureException {
        return (T)BasicContext.throwIfNull(name, value, v -> v);
    }

    private static <T, U> T throwIfNull(String name, U value, Function<U, T> producer) throws ProcedureException {
        if (value == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "There is no `%s` in the current procedure call context.", new Object[]{name});
        }
        return producer.apply(value);
    }

    public static class ContextBuilder {
        private DependencyResolver resolver;
        private Transaction procedureTransaction;
        private InternalTransaction internalTransaction;
        private SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        private ClockContext clockContext;
        private Thread thread = Thread.currentThread();
        private ValueMapper<Object> valueMapper;
        private ProcedureCallContext procedureCallContext;

        private ContextBuilder(DependencyResolver resolver, ValueMapper<Object> valueMapper) {
            this.resolver = resolver;
            this.valueMapper = valueMapper;
        }

        public ContextBuilder withProcedureTransaction(Transaction procedureTransaction) {
            this.procedureTransaction = procedureTransaction;
            return this;
        }

        public ContextBuilder withInternalTransaction(InternalTransaction internalTransaction) {
            this.internalTransaction = internalTransaction;
            return this;
        }

        public ContextBuilder withSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public ContextBuilder withClock(ClockContext clockContext) {
            this.clockContext = clockContext;
            return this;
        }

        public ContextBuilder withProcedureCallContext(ProcedureCallContext procedureContext) {
            this.procedureCallContext = procedureContext;
            return this;
        }

        public Context context() {
            Objects.requireNonNull(this.resolver);
            Objects.requireNonNull(this.securityContext);
            Objects.requireNonNull(this.valueMapper);
            Objects.requireNonNull(this.thread);
            return new BasicContext(this.resolver, this.procedureTransaction, this.internalTransaction, this.securityContext, this.clockContext, this.valueMapper, this.thread, this.procedureCallContext);
        }
    }
}

