/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.logging.Level;
import org.neo4j.values.storable.DurationValue;

public final class CommunityTopologyGraphDbmsModelUtil {
    private CommunityTopologyGraphDbmsModelUtil() {
    }

    static Stream<DatabaseReference.Internal> getAllPrimaryStandardDatabaseReferencesInRoot(Transaction tx) {
        return tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL).stream().filter(node -> !node.hasProperty("virtual")).map(CommunityTopologyGraphDbmsModelUtil::getDatabaseId).map(CommunityTopologyGraphDbmsModelUtil::primaryRefFromDatabaseId);
    }

    private static DatabaseReference.Internal primaryRefFromDatabaseId(NamedDatabaseId databaseId) {
        NormalizedDatabaseName alias = new NormalizedDatabaseName(databaseId.name());
        return new DatabaseReference.Internal(alias, databaseId, true);
    }

    static NormalizedDatabaseName getNameProperty(String labelName, Node node) {
        return new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(labelName, node, "name", String.class));
    }

    static TopologyGraphDbmsModel.DatabaseAccess getDatabaseAccess(Node databaseNode) {
        String accessString = (String)databaseNode.getProperty("access", (Object)TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
        return Enum.valueOf(TopologyGraphDbmsModel.DatabaseAccess.class, accessString);
    }

    public static Optional<DatabaseReference.Internal> createInternalReference(Node alias, NamedDatabaseId targetedDatabase) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "name", String.class));
            NormalizedDatabaseName namespace = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "namespace", String.class));
            Boolean primary = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, alias, "primary", Boolean.class);
            return Optional.of(new DatabaseReference.Internal(aliasName, namespace, targetedDatabase, primary));
        });
    }

    public static Optional<DatabaseReference.External> createExternalReference(Node ref) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            String uriString = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "url", String.class);
            NormalizedDatabaseName targetName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "target_name", String.class));
            NormalizedDatabaseName aliasName = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "name", String.class));
            NormalizedDatabaseName namespace = new NormalizedDatabaseName(CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "namespace", String.class));
            URI uri = URI.create(uriString);
            SocketAddress host = SocketAddressParser.socketAddress((URI)uri, (int)7687, SocketAddress::new);
            RemoteUri remoteUri = new RemoteUri(uri.getScheme(), List.of(host), uri.getQuery());
            String uuid = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode("Remote Database alias", ref, "version", String.class);
            return Optional.of(new DatabaseReference.External(targetName, aliasName, namespace, remoteUri, UUID.fromString(uuid)));
        });
    }

    public static Optional<DriverSettings> getDriverSettings(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            List connectsWith = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.CONNECTS_WITH_RELATIONSHIP}).spliterator(), false).toList();
            return connectsWith.stream().findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModelUtil::createDriverSettings);
        });
    }

    public static Optional<Map<String, Object>> getAliasProperties(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            List propertiesRels = StreamSupport.stream(aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.PROPERTIES_RELATIONSHIP}).spliterator(), false).toList();
            return propertiesRels.stream().findFirst().map(Relationship::getEndNode).map(Entity::getAllProperties);
        });
    }

    public static Optional<ExternalDatabaseCredentials> getDatabaseCredentials(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            String username = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.REMOTE_DATABASE, aliasNode, "username", String.class);
            byte[] password = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.REMOTE_DATABASE, aliasNode, "password", byte[].class);
            byte[] iv = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.REMOTE_DATABASE, aliasNode, "iv", byte[].class);
            return Optional.of(new ExternalDatabaseCredentials(username, password, iv));
        });
    }

    private static DriverSettings createDriverSettings(Node driverSettingsNode) {
        DriverSettings.Builder builder = DriverSettings.builder();
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "ssl_enforced", Boolean.class).ifPresent(builder::withSslEnforced);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_timeout", DurationValue.class).ifPresent(builder::withConnectionTimeout);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_max_lifetime", DurationValue.class).ifPresent(builder::withConnectionMaxLifeTime);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, DriverSettings.Keys.CONNECTION_POOL_ACQUISITION_TIMEOUT.toString(), DurationValue.class).ifPresent(builder::withConnectionPoolAcquisitionTimeout);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_pool_idle_test", DurationValue.class).ifPresent(builder::withConnectionPoolIdleTest);
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "connection_pool_max_size", Number.class).ifPresent(value -> builder.withConnectionPoolMaxSize(value.intValue()));
        CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DRIVER_SETTINGS, driverSettingsNode, "logging_level", String.class).ifPresent(level -> builder.withLoggingLevel(Level.valueOf((String)level)));
        return builder.build();
    }

    static Optional<DatabaseReference> getInternalDatabaseReference(Transaction tx, String databaseName) {
        Optional<Node> aliasNode = CommunityTopologyGraphDbmsModelUtil.findAliasNodeInDefaultNamespace(tx, databaseName);
        return aliasNode.flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabase(alias).flatMap(db -> CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, db)));
    }

    static Optional<DatabaseReference> getExternalDatabaseReference(Transaction tx, String databaseName) {
        return Optional.ofNullable(tx.findNode(TopologyGraphDbmsModel.REMOTE_DATABASE_LABEL, "name", (Object)databaseName)).flatMap(CommunityTopologyGraphDbmsModelUtil::createExternalReference);
    }

    static Optional<NamedDatabaseId> getDatabaseIdByAlias(Transaction tx, String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.findAliasNodeInDefaultNamespace(tx, databaseName).flatMap(CommunityTopologyGraphDbmsModelUtil::getTargetedDatabase);
    }

    static Optional<NamedDatabaseId> getDatabaseIdBy(Transaction tx, String propertyKey, String propertyValue) {
        try {
            Node node = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, propertyKey, (Object)propertyValue);
            if (node == null) {
                return Optional.empty();
            }
            String databaseName = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_LABEL.name(), node, "name", String.class);
            String databaseUuid = CommunityTopologyGraphDbmsModelUtil.getPropertyOnNode(TopologyGraphDbmsModel.DATABASE_LABEL.name(), node, "uuid", String.class);
            return Optional.of(DatabaseIdFactory.from((String)databaseName, (UUID)UUID.fromString(databaseUuid)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<NamedDatabaseId> getTargetedDatabase(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            try (Stream stream = aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.TARGETS_RELATIONSHIP}).stream();){
                Optional<NamedDatabaseId> optional = stream.findFirst().map(Relationship::getEndNode).map(CommunityTopologyGraphDbmsModelUtil::getDatabaseId);
                return optional;
            }
        });
    }

    public static Optional<Node> getTargetedDatabaseNode(Node aliasNode) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            try (Stream stream = aliasNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.TARGETS_RELATIONSHIP}).stream();){
                Optional<Node> optional = stream.findFirst().map(Relationship::getEndNode);
                return optional;
            }
        });
    }

    static NamedDatabaseId getDatabaseId(Node databaseNode) {
        String name = (String)databaseNode.getProperty("name");
        UUID uuid = UUID.fromString((String)databaseNode.getProperty("uuid"));
        return DatabaseIdFactory.from((String)name, (UUID)uuid);
    }

    private static <T> Optional<T> getOptionalPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value;
        try {
            value = node.getProperty(key);
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
        if (value == null) {
            return Optional.empty();
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return Optional.of(type.cast(value));
    }

    private static <T> T getPropertyOnNode(String labelName, Node node, String key, Class<T> type) {
        Object value = node.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(String.format("%s has no property %s.", labelName, key));
        }
        if (!type.isInstance(value)) {
            throw new IllegalStateException(String.format("%s has non %s property %s.", labelName, type.getSimpleName(), key));
        }
        return type.cast(value);
    }

    private static Optional<Node> findAliasNodeInDefaultNamespace(Transaction tx, String databaseName) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", (Object)databaseName);){
            Optional<Node> optional = nodes.stream().filter(n -> CommunityTopologyGraphDbmsModelUtil.getOptionalPropertyOnNode(TopologyGraphDbmsModel.DATABASE_NAME, n, "namespace", String.class).orElse("system-root").equals("system-root")).findFirst();
            return optional;
        }
    }

    static <T> Optional<T> ignoreConcurrentDeletes(Supplier<Optional<T>> operation) {
        try {
            return operation.get();
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }
}

