/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.storageengine.api.CommandBatch;

public class TransactionIdTracker {
    private final MutableLongSet completedTransactions = LongSets.mutable.empty();
    private final MutableLongSet notCompletedTransactions = LongSets.mutable.empty();

    boolean isCompletedTransaction(long transactionId) {
        return !this.notCompletedTransactions.contains(transactionId);
    }

    public void trackBatch(CommittedCommandBatch committedBatch) {
        CommandBatch commandBatch = committedBatch.commandBatch();
        if (commandBatch.isFirst() && commandBatch.isLast()) {
            return;
        }
        long transactionId = committedBatch.txId();
        if (commandBatch.isLast()) {
            this.completedTransactions.add(transactionId);
        } else {
            if (!this.completedTransactions.contains(transactionId)) {
                this.notCompletedTransactions.add(transactionId);
            }
            if (commandBatch.isFirst()) {
                this.completedTransactions.remove(transactionId);
            }
        }
    }
}

