/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextNode;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextRelationship;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextValueMapper;
import org.neo4j.kernel.impl.util.BaseCoreAPIPath;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValueUtils {
    private ValueUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static AnyValue of(Object object) {
        return ValueUtils.of(object, false);
    }

    public static AnyValue of(Object object, boolean wrapEntities) {
        if (object instanceof AnyValue) {
            return (AnyValue)object;
        }
        Value value = Values.unsafeOf((Object)object, (boolean)true);
        if (value != null) {
            return value;
        }
        if (object instanceof Entity) {
            if (object instanceof Node) {
                if (wrapEntities) {
                    return ValueUtils.maybeWrapNodeEntity((Node)object);
                }
                return ValueUtils.fromNodeEntity((Node)object);
            }
            if (object instanceof Relationship) {
                if (wrapEntities) {
                    return ValueUtils.maybeWrapRelationshipEntity((Relationship)object);
                }
                return ValueUtils.fromRelationshipEntity((Relationship)object);
            }
            throw new IllegalArgumentException("Unknown entity + " + object.getClass().getName());
        }
        if (object instanceof Iterable) {
            if (object instanceof Path) {
                if (wrapEntities) {
                    return ValueUtils.maybeWrapPath((Path)object);
                }
                return ValueUtils.pathReferenceFromPath((Path)object);
            }
            if (object instanceof List) {
                return ValueUtils.asListValue((List)object, wrapEntities);
            }
            return ValueUtils.asListValue((Iterable)object, wrapEntities);
        }
        if (object instanceof Map) {
            return ValueUtils.asMapValue((Map)object, wrapEntities);
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            ListValueBuilder builder = ListValueBuilder.newListBuilder();
            while (iterator.hasNext()) {
                builder.add(ValueUtils.of(iterator.next(), wrapEntities));
            }
            return builder.build();
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (array.length == 0) {
                return VirtualValues.EMPTY_LIST;
            }
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)array.length);
            for (Object o : array) {
                builder.add(ValueUtils.of(o, wrapEntities));
            }
            return builder.build();
        }
        if (object instanceof Stream) {
            return ValueUtils.asListValue(((Stream)object).collect(Collectors.toList()));
        }
        if (object instanceof Geometry) {
            return ValueUtils.asGeometryValue((Geometry)object);
        }
        ClassLoader classLoader = object.getClass().getClassLoader();
        throw new IllegalArgumentException(String.format("Cannot convert %s of type %s to AnyValue, classloader=%s, classloader-name=%s", object, object.getClass().getName(), classLoader != null ? classLoader.toString() : "null", classLoader != null ? classLoader.getName() : "null"));
    }

    public static PointValue asPointValue(Point point) {
        return ValueUtils.toPoint((Geometry)point);
    }

    public static PointValue asGeometryValue(Geometry geometry) {
        if (!geometry.getGeometryType().equals("Point")) {
            throw new IllegalArgumentException("Cannot handle geometry type: " + geometry.getCRS().getType());
        }
        return ValueUtils.toPoint(geometry);
    }

    private static PointValue toPoint(Geometry geometry) {
        double[] coordinatesCopy = ((Coordinate)geometry.getCoordinates().get(0)).getCoordinateCopy();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.get((CRS)geometry.getCRS()), (double[])coordinatesCopy);
    }

    public static ListValue asListValue(List<?> collection) {
        return ValueUtils.asListValue(collection, false);
    }

    public static ListValue asListValue(List<?> collection, boolean wrapEntities) {
        int size = collection.size();
        if (size == 0) {
            return VirtualValues.EMPTY_LIST;
        }
        ListValueBuilder values = ListValueBuilder.newListBuilder((int)size);
        for (Object o : collection) {
            values.add(ValueUtils.of(o, wrapEntities));
        }
        return values.build();
    }

    public static ListValue asListValue(Iterable<?> collection) {
        return ValueUtils.asListValue(collection, false);
    }

    public static ListValue asListValue(Iterable<?> collection, boolean wrapEntities) {
        ListValueBuilder values = ListValueBuilder.newListBuilder();
        for (Object o : collection) {
            values.add(ValueUtils.of(o, wrapEntities));
        }
        return values.build();
    }

    public static AnyValue asNodeOrEdgeValue(Entity container) {
        if (container instanceof Node) {
            return ValueUtils.fromNodeEntity((Node)container);
        }
        if (container instanceof Relationship) {
            return ValueUtils.fromRelationshipEntity((Relationship)container);
        }
        throw new IllegalArgumentException("Cannot produce a node or edge from " + container.getClass().getName());
    }

    public static ListValue asListOfEdges(Iterable<Relationship> rels) {
        return VirtualValues.list((AnyValue[])((AnyValue[])StreamSupport.stream(rels.spliterator(), false).map(ValueUtils::fromRelationshipEntity).toArray(VirtualRelationshipValue[]::new)));
    }

    public static ListValue asListOfEdges(Relationship[] rels) {
        if (rels.length == 0) {
            return VirtualValues.EMPTY_LIST;
        }
        ListValueBuilder relValues = ListValueBuilder.newListBuilder((int)rels.length);
        for (Relationship rel : rels) {
            relValues.add((AnyValue)ValueUtils.fromRelationshipEntity(rel));
        }
        return relValues.build();
    }

    public static MapValue asMapValue(Map<String, ?> map) {
        return ValueUtils.asMapValue(map, false);
    }

    public static MapValue asMapValue(Map<String, ?> map, boolean wrapEntities) {
        int size = map.size();
        if (size == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(size);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            builder.add(entry.getKey(), ValueUtils.of(entry.getValue(), wrapEntities));
        }
        return builder.build();
    }

    public static MapValue asParameterMapValue(Map<String, Object> map) {
        int size = map.size();
        if (size == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(size);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                builder.add(entry.getKey(), ValueUtils.of(entry.getValue(), true));
            }
            catch (IllegalArgumentException e) {
                builder.add(entry.getKey(), (AnyValue)VirtualValues.error((Exception)e));
            }
        }
        return builder.build();
    }

    public static VirtualNodeValue fromNodeEntity(Node node) {
        return ValueUtils.asNodeReference(node);
    }

    public static VirtualNodeReference asNodeReference(Node node) {
        if (node.getId() < 0L) {
            return new NodeEntityWrappingNodeValue(node);
        }
        return VirtualValues.node((long)node.getId(), (String)node.getElementId());
    }

    @Deprecated
    public static VirtualNodeValue wrapNodeEntity(Node node) {
        return new NodeEntityWrappingNodeValue(node);
    }

    @Deprecated
    public static VirtualNodeValue maybeWrapNodeEntity(Node node) {
        if (node instanceof ExecutionContextNode) {
            return ValueUtils.fromNodeEntity(node);
        }
        return ValueUtils.wrapNodeEntity(node);
    }

    public static VirtualRelationshipValue fromRelationshipEntity(Relationship relationship) {
        if (relationship.getId() < 0L) {
            return ValueUtils.wrapRelationshipEntity(relationship);
        }
        return VirtualValues.relationship((long)relationship.getId());
    }

    @Deprecated
    public static VirtualRelationshipValue wrapRelationshipEntity(Relationship relationship) {
        return RelationshipEntityWrappingValue.wrapLazy(relationship);
    }

    @Deprecated
    public static VirtualRelationshipValue maybeWrapRelationshipEntity(Relationship relationship) {
        if (relationship instanceof ExecutionContextRelationship) {
            return ValueUtils.fromRelationshipEntity(relationship);
        }
        return ValueUtils.wrapRelationshipEntity(relationship);
    }

    public static VirtualPathValue fromPath(Path path) {
        return VirtualValues.pathReference((VirtualNodeValue[])((VirtualNodeValue[])StreamSupport.stream(path.nodes().spliterator(), false).map(ValueUtils::fromNodeEntity).toArray(VirtualNodeValue[]::new)), (VirtualRelationshipValue[])((VirtualRelationshipValue[])StreamSupport.stream(path.relationships().spliterator(), false).map(ValueUtils::fromRelationshipEntity).toArray(VirtualRelationshipValue[]::new)));
    }

    @Deprecated
    public static VirtualPathValue wrapPath(Path path) {
        return new PathWrappingPathValue(path);
    }

    @Deprecated
    public static VirtualPathValue maybeWrapPath(Path path) {
        if (path instanceof ExecutionContextValueMapper.ExecutionContextPath) {
            return ValueUtils.pathReferenceFromPath(path);
        }
        return new PathWrappingPathValue(path);
    }

    public static VirtualPathValue pathReferenceFromPath(Path path) {
        if (path instanceof BaseCoreAPIPath) {
            return ((BaseCoreAPIPath)path).pathValue();
        }
        int len = path.length();
        long[] nodes = new long[len + 1];
        long[] rels = new long[len];
        Iterator nodeIterator = path.nodes().iterator();
        Iterator relIterator = path.relationships().iterator();
        for (int i = 0; i < len; ++i) {
            nodes[i] = ((Node)nodeIterator.next()).getId();
            rels[i] = ((Relationship)relIterator.next()).getId();
        }
        nodes[i] = ((Node)nodeIterator.next()).getId();
        return VirtualValues.pathReference((long[])nodes, (long[])rels);
    }

    public static Value asValue(Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        return Values.of((Object)value);
    }

    public static AnyValue asAnyValue(Object value) {
        if (value instanceof AnyValue) {
            return (AnyValue)value;
        }
        return ValueUtils.of(value);
    }

    public static VirtualNodeValue asNodeValue(Object object) {
        if (object instanceof VirtualNodeValue) {
            return (VirtualNodeValue)object;
        }
        if (object instanceof Node) {
            return ValueUtils.fromNodeEntity((Node)object);
        }
        throw new IllegalArgumentException("Cannot produce a node from " + object.getClass().getName());
    }

    public static VirtualRelationshipValue asRelationshipValue(Object object) {
        if (object instanceof VirtualRelationshipValue) {
            return (VirtualRelationshipValue)object;
        }
        if (object instanceof Relationship) {
            return ValueUtils.fromRelationshipEntity((Relationship)object);
        }
        throw new IllegalArgumentException("Cannot produce a relationship from " + object.getClass().getName());
    }

    public static LongValue asLongValue(Object object) {
        if (object instanceof LongValue) {
            return (LongValue)object;
        }
        if (object instanceof Long) {
            return Values.longValue((long)((Long)object));
        }
        if (object instanceof IntValue) {
            return Values.longValue((long)((IntValue)object).longValue());
        }
        if (object instanceof Integer) {
            return Values.longValue((long)((Integer)object).intValue());
        }
        throw new IllegalArgumentException("Cannot produce a long from " + object.getClass().getName());
    }

    public static DoubleValue asDoubleValue(Object object) {
        if (object instanceof DoubleValue) {
            return (DoubleValue)object;
        }
        if (object instanceof Double) {
            return Values.doubleValue((double)((Double)object));
        }
        throw new IllegalArgumentException("Cannot produce a double from " + object.getClass().getName());
    }

    public static BooleanValue asBooleanValue(Object object) {
        if (object instanceof BooleanValue) {
            return (BooleanValue)object;
        }
        if (object instanceof Boolean) {
            return Values.booleanValue((boolean)((Boolean)object));
        }
        throw new IllegalArgumentException("Cannot produce a boolean from " + object.getClass().getName());
    }

    public static TextValue asTextValue(Object object) {
        if (object instanceof TextValue) {
            return (TextValue)object;
        }
        if (object instanceof String) {
            return Values.utf8Value((String)((String)object));
        }
        throw new IllegalArgumentException("Cannot produce a string from " + object.getClass().getName());
    }
}

