/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.QueueTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionLogQueue;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Panic;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionAppenderFactory {
    public static TransactionAppender createTransactionAppender(LogFiles logFiles, TransactionIdStore transactionIdStore, Config config, Panic databasePanic, JobScheduler scheduler, InternalLogProvider logProvider) {
        if (((Boolean)config.get(GraphDatabaseInternalSettings.dedicated_transaction_appender)).booleanValue()) {
            TransactionLogQueue queue = new TransactionLogQueue(logFiles, transactionIdStore, databasePanic, scheduler, logProvider);
            return new QueueTransactionAppender(queue);
        }
        return new BatchingTransactionAppender(logFiles, transactionIdStore, databasePanic);
    }
}

