/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public class CompleteTransaction
implements CommandBatch {
    private final List<StorageCommand> commands;
    private final long timeStarted;
    private final long latestCommittedTxWhenStarted;
    private final long timeCommitted;
    private final KernelVersion kernelVersion;
    private final Subject subject;
    private final int leaseId;
    private byte[] additionalHeader;

    public CompleteTransaction(List<StorageCommand> commands, byte[] additionalHeader, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, int leaseId, KernelVersion kernelVersion, Subject subject) {
        this.commands = commands;
        this.additionalHeader = additionalHeader;
        this.timeStarted = timeStarted;
        this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        this.timeCommitted = timeCommitted;
        this.leaseId = leaseId;
        this.kernelVersion = kernelVersion;
        this.subject = subject;
    }

    public void setAdditionalHeader(byte[] additionalHeader) {
        this.additionalHeader = additionalHeader;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.commands) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    public byte[] additionalHeader() {
        return this.additionalHeader;
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public long getLatestCommittedTxWhenStarted() {
        return this.latestCommittedTxWhenStarted;
    }

    public long getTimeCommitted() {
        return this.timeCommitted;
    }

    public int getLeaseId() {
        return this.leaseId;
    }

    public Subject subject() {
        return this.subject;
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteTransaction that = (CompleteTransaction)o;
        return this.latestCommittedTxWhenStarted == that.latestCommittedTxWhenStarted && this.timeStarted == that.timeStarted && Arrays.equals(this.additionalHeader, that.additionalHeader) && this.commands.equals(that.commands);
    }

    public int hashCode() {
        int result = this.commands.hashCode();
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + (int)(this.timeStarted ^ this.timeStarted >>> 32);
        result = 31 * result + (int)(this.latestCommittedTxWhenStarted ^ this.latestCommittedTxWhenStarted >>> 32);
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeCommands) {
        String basic = String.format("%s[timeStarted:%d, latestCommittedTxWhenStarted:%d, timeCommitted:%d, lease:%d, additionalHeader:%s, commands.length:%d", this.getClass().getSimpleName(), this.timeStarted, this.latestCommittedTxWhenStarted, this.timeCommitted, this.leaseId, Arrays.toString(this.additionalHeader), this.commands.size());
        if (!includeCommands) {
            return basic;
        }
        StringBuilder builder = new StringBuilder(basic);
        for (StorageCommand command : this.commands) {
            builder.append(String.format("%n%s", command.toString()));
        }
        return builder.toString();
    }

    public boolean isLast() {
        return true;
    }

    public boolean isFirst() {
        return true;
    }

    public Iterator<StorageCommand> iterator() {
        return this.commands.iterator();
    }

    public int commandCount() {
        return this.commands.size();
    }
}

