/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import org.neo4j.kernel.impl.transaction.CommittedChunkRepresentation;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.v54.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.entry.v54.LogEntryChunkStart;
import org.neo4j.storageengine.api.StorageCommand;

public class CommittedCommandBatchCursor
implements CommandBatchCursor {
    private final ReadableClosablePositionAwareChecksumChannel channel;
    private final LogEntryCursor logEntryCursor;
    private final LogPositionMarker lastGoodPositionMarker = new LogPositionMarker();
    private CommittedCommandBatch current;

    public CommittedCommandBatchCursor(ReadableClosablePositionAwareChecksumChannel channel, LogEntryReader entryReader) throws IOException {
        this.channel = channel;
        channel.getCurrentPosition(this.lastGoodPositionMarker);
        this.logEntryCursor = new LogEntryCursor(entryReader, channel);
    }

    public CommittedCommandBatch get() {
        return this.current;
    }

    /*
     * Unable to fully structure code
     */
    public boolean next() throws IOException {
        block5: {
            this.current = null;
            if (!this.logEntryCursor.next()) {
                return false;
            }
            entry = this.logEntryCursor.get();
            entries = new ArrayList<StorageCommand>();
            if (!(entry instanceof LogEntryStart) && !(entry instanceof LogEntryChunkStart)) break block5;
            startEntry = entry;
            while (true) {
                if (!this.logEntryCursor.next()) {
                    return false;
                }
                entry = this.logEntryCursor.get();
                if (entry instanceof LogEntryCommit || entry instanceof LogEntryChunkEnd) break;
                command = (LogEntryCommand)entry;
                entries.add(command.getCommand());
            }
            endEntry = entry;
            if (!(startEntry instanceof LogEntryStart)) ** GOTO lbl-1000
            entryStart = (LogEntryStart)startEntry;
            if (endEntry instanceof LogEntryCommit) {
                commitEntry = (LogEntryCommit)endEntry;
                this.current = new CommittedTransactionRepresentation(entryStart, entries, commitEntry);
            } else lbl-1000:
            // 2 sources

            {
                this.current = CommittedChunkRepresentation.createChunkRepresentation(startEntry, entries, endEntry);
            }
            this.channel.getCurrentPosition(this.lastGoodPositionMarker);
            return true;
        }
        throw new IllegalStateException("Was expecting transaction or chunk start but got: " + entry);
    }

    public void close() throws IOException {
        this.logEntryCursor.close();
    }

    @Override
    public LogPosition position() {
        return this.lastGoodPositionMarker.newPosition();
    }
}

