/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.impl.storemigration.UnableToMigrateException;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;

class LogsMigrator {
    private static final String MIGRATION_CHECKPOINT = "Migration checkpoint.";
    private final FileSystemAbstraction fs;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseLayout databaseLayout;
    private final PageCache pageCache;
    private final Config config;
    private final CursorContextFactory contextFactory;
    private final Supplier<LogTailMetadata> logTailSupplier;
    private final PageCacheTracer pageCacheTracer;

    LogsMigrator(FileSystemAbstraction fs, StorageEngineFactory storageEngineFactory, DatabaseLayout databaseLayout, PageCache pageCache, Config config, CursorContextFactory contextFactory, Supplier<LogTailMetadata> logTailSupplier, PageCacheTracer pageCacheTracer) {
        this.fs = fs;
        this.storageEngineFactory = storageEngineFactory;
        this.databaseLayout = databaseLayout;
        this.pageCache = pageCache;
        this.config = config;
        this.contextFactory = contextFactory;
        this.logTailSupplier = logTailSupplier;
        this.pageCacheTracer = pageCacheTracer;
    }

    CheckResult assertCleanlyShutDown() {
        LogTailMetadata logTail;
        try {
            logTail = this.logTailSupplier.get();
        }
        catch (Throwable throwable) {
            throw new UnableToMigrateException("Failed to verify the transaction logs. This most likely means that the transaction logs are corrupted.", throwable);
        }
        if (logTail.logsMissing()) {
            if (((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                throw new UnableToMigrateException("Transaction logs not found");
            }
            return new CheckResult(true, 1L);
        }
        if (logTail.isRecoveryRequired()) {
            throw new UnableToMigrateException("The database is not cleanly shutdown. The database needs recovery, in order to recover the database, please run the version of the DBMS you are migrating from on this store.");
        }
        return new CheckResult(false, logTail.getLastCommittedTransaction().transactionId());
    }

    private MetadataProvider getMetaDataStore() throws IOException {
        return this.storageEngineFactory.transactionMetaDataStore(this.fs, this.databaseLayout, this.config, this.pageCache, DatabaseReadOnlyChecker.readOnly(), this.contextFactory, this.logTailSupplier.get(), this.pageCacheTracer);
    }

    class CheckResult {
        private final boolean logsMissing;
        private final long lastTxId;

        private CheckResult(boolean logsMissing, long lastTxId) {
            this.logsMissing = logsMissing;
            this.lastTxId = lastTxId;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        MigrationTransactionIds migrate() {
            try (MetadataProvider store = LogsMigrator.this.getMetaDataStore();){
                MetadataCache metadataCache = new MetadataCache(KernelVersion.LATEST);
                TransactionLogInitializer logInitializer = new TransactionLogInitializer(LogsMigrator.this.fs, store, LogsMigrator.this.storageEngineFactory, metadataCache);
                Path transactionLogsDirectory = LogsMigrator.this.databaseLayout.getTransactionLogsDirectory();
                if (this.logsMissing) {
                    MigrationTransactionIds migrationTransactionIds2 = new MigrationTransactionIds(1L, logInitializer.initializeEmptyLogFile(LogsMigrator.this.databaseLayout, transactionLogsDirectory, LogsMigrator.MIGRATION_CHECKPOINT));
                    return migrationTransactionIds2;
                }
                MigrationTransactionIds migrationTransactionIds = new MigrationTransactionIds(this.lastTxId, logInitializer.migrateExistingLogFiles(LogsMigrator.this.databaseLayout, transactionLogsDirectory, LogsMigrator.MIGRATION_CHECKPOINT));
                return migrationTransactionIds;
            }
            catch (Exception exception) {
                throw new UnableToMigrateException("Failure on attempt to migrate transaction logs to new version.", exception);
            }
        }

        MigrationTransactionIds upgrade() {
            MigrationTransactionIds migrationTransactionIds;
            block9: {
                if (!this.logsMissing) {
                    return new MigrationTransactionIds(this.lastTxId, this.lastTxId);
                }
                MetadataProvider store = LogsMigrator.this.getMetaDataStore();
                try {
                    MetadataCache metadataCache = new MetadataCache(LogsMigrator.this.logTailSupplier.get());
                    TransactionLogInitializer logInitializer = new TransactionLogInitializer(LogsMigrator.this.fs, store, LogsMigrator.this.storageEngineFactory, metadataCache);
                    Path transactionLogsDirectory = LogsMigrator.this.databaseLayout.getTransactionLogsDirectory();
                    migrationTransactionIds = new MigrationTransactionIds(1L, logInitializer.initializeEmptyLogFile(LogsMigrator.this.databaseLayout, transactionLogsDirectory, LogsMigrator.MIGRATION_CHECKPOINT));
                    if (store == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (store != null) {
                            try {
                                store.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw new UnableToMigrateException("Failure on attempt to upgrade transaction logs to new version.", exception);
                    }
                }
                store.close();
            }
            return migrationTransactionIds;
        }
    }

    record MigrationTransactionIds(long txIdBeforeMigration, long txIdAfterMigration) {
    }
}

