/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.api.TransactionCommitter;
import org.neo4j.kernel.impl.api.commit.ChunkedTransactionSink;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.memory.MemoryTracker;

public class ChunkSink
implements ChunkedTransactionSink {
    private final TransactionClockContext clocks;
    private final long chunkSize;
    private final TransactionCommitter committer;

    public ChunkSink(TransactionCommitter committer, TransactionClockContext clocks, Config config) {
        this.clocks = clocks;
        this.chunkSize = (Long)config.get(GraphDatabaseInternalSettings.multi_version_transaction_chunk_size);
        this.committer = committer;
    }

    @Override
    public void write(TxState txState, TransactionEvent transactionEvent) {
        MemoryTracker memoryTracker = txState.memoryTracker();
        if (memoryTracker.estimatedHeapMemory() > this.chunkSize) {
            try (CommitEvent commitEvent = transactionEvent.beginCommitEvent();){
                this.committer.commit(commitEvent, this.clocks.systemClock().millis(), memoryTracker, false);
                txState.reset();
            }
            catch (KernelException ke) {
                throw new RuntimeException("Fail to append transaction chunk.", ke);
            }
        }
    }
}

