/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.LongConsumer;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class TransactionToApply
implements CommandBatchToApply {
    public static final long TRANSACTION_ID_NOT_SPECIFIED = 0L;
    public static final int NOT_SPECIFIED_CHUNK_ID = 0;
    private final CommandBatch commandBatch;
    private boolean idGenerated;
    private long transactionId;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private final TransactionIdGenerator transactionIdGenerator;
    private CommandBatchToApply next;
    private final Commitment commitment;
    private LongConsumer closedCallback;

    public TransactionToApply(CommittedCommandBatch committedCommandBatch, CursorContext cursorContext, StoreCursors storeCursors) {
        this(committedCommandBatch, cursorContext, storeCursors, Commitment.NO_COMMITMENT, TransactionIdGenerator.EXTERNAL_ID);
    }

    public TransactionToApply(CommittedCommandBatch committedCommandBatch, CursorContext cursorContext, StoreCursors storeCursors, Commitment commitment, TransactionIdGenerator transactionIdGenerator) {
        this(committedCommandBatch.commandBatch(), cursorContext, storeCursors, commitment, transactionIdGenerator);
        this.transactionId = committedCommandBatch.txId();
    }

    public TransactionToApply(CommandBatch commandBatch, CursorContext cursorContext, StoreCursors storeCursors, Commitment commitment, TransactionIdGenerator transactionIdGenerator) {
        this.commandBatch = commandBatch;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
        this.commitment = commitment;
        this.transactionIdGenerator = transactionIdGenerator;
    }

    public void next(CommandBatchToApply next) {
        this.next = next;
    }

    public void commit() {
        this.commitment.publishAsCommitted(this.commandBatch.getTimeCommitted());
    }

    public long transactionId() {
        if (this.idGenerated) {
            return this.transactionId;
        }
        this.transactionId = this.transactionIdGenerator.nextId(this.transactionId);
        this.idGenerated = true;
        return this.transactionId;
    }

    public long chunkId() {
        return 0L;
    }

    public Subject subject() {
        return this.commandBatch.subject();
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public StoreCursors storeCursors() {
        return this.storeCursors;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        return this.commandBatch.accept(visitor);
    }

    public CommandBatch commandBatch() {
        return this.commandBatch;
    }

    public void batchAppended(LogPosition beforeCommit, LogPosition positionAfter, int checksum) {
        this.commitment.commit(this.transactionId, beforeCommit, positionAfter, checksum);
        this.cursorContext.getVersionContext().initWrite(this.transactionId);
    }

    public CommandBatchToApply next() {
        return this.next;
    }

    public void onClose(LongConsumer closedCallback) {
        this.closedCallback = closedCallback;
    }

    public void close() {
        this.commitment.publishAsClosed();
        if (this.closedCallback != null) {
            this.closedCallback.accept(this.transactionId);
        }
    }

    public String toString() {
        CommandBatch tr = this.commandBatch;
        return "Transaction #" + this.transactionId + " {started " + Format.date((long)tr.getTimeStarted()) + ", committed " + Format.date((long)tr.getTimeCommitted()) + ", with " + this.countCommands() + " commands in this transaction, lease " + tr.getLeaseId() + ", latest committed transaction id when started was " + tr.getLatestCommittedTxWhenStarted() + ", additional header bytes: " + Format.hexString((byte[])tr.additionalHeader()) + "}";
    }

    private String countCommands() {
        try {
            class Counter
            implements Visitor<StorageCommand, IOException> {
                private int count;

                Counter() {
                }

                public boolean visit(StorageCommand element) {
                    ++this.count;
                    return false;
                }
            }
            Counter counter = new Counter();
            this.accept(counter);
            return String.valueOf(counter.count);
        }
        catch (Throwable e) {
            return "(unable to count: " + e.getMessage() + ")";
        }
    }

    public Iterator<StorageCommand> iterator() {
        return this.commandBatch.iterator();
    }
}

