/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModelUtil;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class CommunityTopologyGraphDbmsModel
implements TopologyGraphDbmsModel {
    protected final Transaction tx;

    public CommunityTopologyGraphDbmsModel(Transaction tx) {
        this.tx = tx;
    }

    public Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> getAllDatabaseAccess() {
        try (ResourceIterator nodes = this.tx.findNodes(DATABASE_LABEL);){
            Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> map = nodes.stream().collect(Collectors.toMap(CommunityTopologyGraphDbmsModelUtil::getDatabaseId, CommunityTopologyGraphDbmsModelUtil::getDatabaseAccess));
            return map;
        }
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.getDatabaseIdByAlias(this.tx, databaseName).or(() -> CommunityTopologyGraphDbmsModelUtil.getDatabaseIdBy(this.tx, "name", databaseName));
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID uuid) {
        return CommunityTopologyGraphDbmsModelUtil.getDatabaseIdBy(this.tx, "uuid", uuid.toString());
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        Stream<DatabaseReference.Internal> primaryRefs = CommunityTopologyGraphDbmsModelUtil.getAllPrimaryStandardDatabaseReferencesInRoot(this.tx);
        Stream<DatabaseReference.Internal> internalAliasRefs = this.getAllInternalDatabaseReferencesInRoot();
        Stream<DatabaseReference.Internal> internalRefs = Stream.concat(primaryRefs, internalAliasRefs);
        Stream<DatabaseReference.External> externalRefs = this.getAllExternalDatabaseReferencesInRoot();
        Stream<DatabaseReference.Composite> compositeRefs = this.getAllCompositeDatabaseReferencesInRoot();
        return Stream.of(internalRefs, externalRefs, compositeRefs).flatMap(s -> s).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReference.Internal> getAllInternalDatabaseReferences() {
        Stream<DatabaseReference.Internal> primaryRefs = CommunityTopologyGraphDbmsModelUtil.getAllPrimaryStandardDatabaseReferencesInRoot(this.tx);
        Stream<DatabaseReference.Internal> localAliasRefs = this.getAllInternalDatabaseReferencesInRoot();
        return Stream.concat(primaryRefs, localAliasRefs).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReference.External> getAllExternalDatabaseReferences() {
        return this.getAllExternalDatabaseReferencesInRoot().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReference.Composite> getAllCompositeDatabaseReferences() {
        return this.getAllCompositeDatabaseReferencesInRoot().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<DatabaseReference> getDatabaseRefByAlias(String databaseName) {
        return this.getCompositeDatabaseReferenceInRoot(databaseName).map(composite -> composite).or(() -> CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReference(this.tx, databaseName)).or(() -> CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReference(this.tx, databaseName));
    }

    @Override
    public Optional<DriverSettings> getDriverSettings(String databaseName, String namespace) {
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getDriverSettings);
    }

    @Override
    public Optional<Map<String, Object>> getAliasProperties(String databaseName, String namespace) {
        return this.tx.findNodes(DATABASE_NAME_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getAliasProperties);
    }

    @Override
    public Optional<ExternalDatabaseCredentials> getExternalDatabaseCredentials(String databaseName, String namespace) {
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getDatabaseCredentials);
    }

    private Stream<DatabaseReference.Composite> getAllCompositeDatabaseReferencesInRoot() {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root").flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(COMPOSITE_DATABASE_LABEL)).flatMap(db -> this.createCompositeReference((Node)alias, (Node)db)).stream());
    }

    private Optional<DatabaseReference.Composite> getCompositeDatabaseReferenceInRoot(String databaseName) {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root", databaseName).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(COMPOSITE_DATABASE_LABEL)).flatMap(db -> this.createCompositeReference((Node)alias, (Node)db)).stream()).findFirst();
    }

    private Optional<DatabaseReference.Composite> createCompositeReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE_NAME, alias);
            NormalizedDatabaseName compositeName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE, db);
            Set<DatabaseReference> components = this.getAllDatabaseReferencesInComposite(compositeName);
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            return Optional.of(new DatabaseReference.Composite(aliasName, databaseId, components));
        });
    }

    private Stream<Node> getAliasNodesInNamespace(Label label, String namespace) {
        return this.tx.findNodes(label, "namespace", (Object)namespace).stream();
    }

    private Stream<Node> getAliasNodesInNamespace(Label label, String namespace, String databaseName) {
        return this.tx.findNodes(label, "namespace", (Object)namespace, "name", (Object)databaseName).stream();
    }

    private Set<DatabaseReference> getAllDatabaseReferencesInComposite(NormalizedDatabaseName compositeName) {
        Stream<DatabaseReference.Internal> internalRefs = this.getAllInternalDatabaseReferencesInNamespace(compositeName.name());
        Stream<DatabaseReference.External> externalRefs = this.getAllExternalDatabaseReferencesInNamespace(compositeName.name());
        return Stream.concat(internalRefs, externalRefs).collect(Collectors.toUnmodifiableSet());
    }

    private Stream<DatabaseReference.External> getAllExternalDatabaseReferencesInRoot() {
        return this.getAllExternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReference.External> getAllExternalDatabaseReferencesInNamespace(String namespace) {
        return this.getAliasNodesInNamespace(REMOTE_DATABASE_LABEL, namespace).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.createExternalReference(alias).stream());
    }

    private Stream<DatabaseReference.Internal> getAllInternalDatabaseReferencesInRoot() {
        return this.getAllInternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReference.Internal> getAllInternalDatabaseReferencesInNamespace(String namespace) {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, namespace).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(node -> !node.hasProperty("virtual")).map(CommunityTopologyGraphDbmsModelUtil::getDatabaseId).flatMap(db -> CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, db)).stream());
    }
}

