/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedMultiFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class PhysicalLogicalTransactionStore
implements LogicalTransactionStore {
    private final LogFile logFile;
    private final TransactionMetadataCache transactionMetadataCache;
    private final CommandReaderFactory commandReaderFactory;
    private final Monitors monitors;
    private final boolean failOnCorruptedLogFiles;
    private final boolean presketchLogFiles;

    public PhysicalLogicalTransactionStore(LogFiles logFiles, TransactionMetadataCache transactionMetadataCache, CommandReaderFactory commandReaderFactory, Monitors monitors, boolean failOnCorruptedLogFiles, Config config) {
        this.logFile = logFiles.getLogFile();
        this.transactionMetadataCache = transactionMetadataCache;
        this.commandReaderFactory = commandReaderFactory;
        this.monitors = monitors;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.presketchLogFiles = (Boolean)config.get(GraphDatabaseInternalSettings.pre_sketch_transaction_logs);
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)this.logFile.getReader(position), (LogEntryReader)new VersionAwareLogEntryReader(this.commandReaderFactory));
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition backToPosition) {
        return ReversedMultiFileTransactionCursor.fromLogFile(this.logFile, backToPosition, (LogEntryReader)new VersionAwareLogEntryReader(this.commandReaderFactory), this.failOnCorruptedLogFiles, (ReversedTransactionCursorMonitor)this.monitors.newMonitor(ReversedTransactionCursorMonitor.class, new String[0]), this.presketchLogFiles);
    }

    @Override
    public TransactionCursor getTransactions(long transactionIdToStartFrom) throws IOException {
        try {
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory);
            TransactionMetadataCache.TransactionMetadata transactionMetadata = this.transactionMetadataCache.getTransactionMetadata(transactionIdToStartFrom);
            if (transactionMetadata != null) {
                ReadableLogChannel channel = this.logFile.getReader(transactionMetadata.startPosition());
                return new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)channel, (LogEntryReader)logEntryReader);
            }
            LogVersionLocator headerVisitor = new LogVersionLocator(transactionIdToStartFrom);
            this.logFile.accept(headerVisitor);
            TransactionPositionLocator transactionPositionLocator = new TransactionPositionLocator(transactionIdToStartFrom, (LogEntryReader)logEntryReader);
            this.logFile.accept(transactionPositionLocator, headerVisitor.getLogPosition());
            LogPosition position = transactionPositionLocator.getLogPosition();
            this.transactionMetadataCache.cacheTransactionMetadata(transactionIdToStartFrom, position);
            return new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)this.logFile.getReader(position), (LogEntryReader)logEntryReader);
        }
        catch (NoSuchFileException e) {
            throw new NoSuchTransactionException(transactionIdToStartFrom, "Log position acquired, but couldn't find the log file itself. Perhaps it just recently was deleted? [" + e.getMessage() + "]", e);
        }
    }

    public static final class LogVersionLocator
    implements LogHeaderVisitor {
        private final long transactionId;
        private LogPosition foundPosition;

        public LogVersionLocator(long transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public boolean visit(LogHeader logHeader, LogPosition position, long firstTransactionIdInLog, long lastTransactionIdInLog) {
            boolean foundIt;
            boolean bl = foundIt = this.transactionId >= firstTransactionIdInLog && this.transactionId <= lastTransactionIdInLog;
            if (foundIt) {
                this.foundPosition = position;
            }
            return !foundIt;
        }

        public LogPosition getLogPosition() throws NoSuchTransactionException {
            if (this.foundPosition == null) {
                throw new NoSuchTransactionException(this.transactionId, "Couldn't find any log containing " + this.transactionId);
            }
            return this.foundPosition;
        }
    }

    public static class TransactionPositionLocator
    implements LogFile.LogFileVisitor {
        private final long startTransactionId;
        private final LogEntryReader logEntryReader;
        private LogEntryStart transactionStartEntry;

        TransactionPositionLocator(long startTransactionId, LogEntryReader logEntryReader) {
            this.startTransactionId = startTransactionId;
            this.logEntryReader = logEntryReader;
        }

        @Override
        public boolean visit(ReadableClosablePositionAwareChecksumChannel channel) throws IOException {
            LogEntry logEntry;
            LogEntryStart startEntry = null;
            block4: while ((logEntry = this.logEntryReader.readLogEntry(channel)) != null) {
                switch (logEntry.getType()) {
                    case 1: {
                        startEntry = (LogEntryStart)logEntry;
                        continue block4;
                    }
                    case 5: {
                        LogEntryCommit commit = (LogEntryCommit)logEntry;
                        if (commit.getTxId() != this.startTransactionId) continue block4;
                        this.transactionStartEntry = startEntry;
                        return false;
                    }
                }
            }
            return true;
        }

        LogPosition getLogPosition() throws NoSuchTransactionException {
            if (this.transactionStartEntry == null) {
                throw new NoSuchTransactionException(this.startTransactionId);
            }
            return this.transactionStartEntry.getStartPosition();
        }
    }
}

