/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.List;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.index.BridgingIndexProgressor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.PointKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.ValueGroup;

class PointIndexReader
extends NativeIndexReader<PointKey> {
    private final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;

    PointIndexReader(GBPTree<PointKey, NullValue> tree, IndexLayout<PointKey> layout, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration) {
        super(tree, layout, descriptor);
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
    }

    @Override
    void validateQuery(IndexQueryConstraints constraints, PropertyIndexQuery[] predicates) {
        if (predicates.length > 1) {
            throw new IllegalArgumentException(String.format("Tried to query a point index with a composite query. Composite queries are not supported by a point index. Query was: %s ", Arrays.toString(predicates)));
        }
        if (constraints.order() != IndexOrder.NONE) {
            throw new IllegalArgumentException("Tried to query a point index with order. Order is not supported by a point index.");
        }
        this.validateSupportedPredicates(predicates[0]);
    }

    private void validateSupportedPredicates(PropertyIndexQuery predicate) {
        switch (predicate.type()) {
            case ALL_ENTRIES: 
            case EXACT: 
            case BOUNDING_BOX: {
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Tried to query index with illegal query. Only %s, %s, and %s queries are supported by a point index. Query was: %s", IndexQuery.IndexQueryType.ALL_ENTRIES, IndexQuery.IndexQueryType.EXACT, IndexQuery.IndexQueryType.BOUNDING_BOX, predicate));
    }

    @Override
    public void query(IndexProgressor.EntityValueClient client, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) {
        if (predicates.length == 0) {
            return;
        }
        PropertyIndexQuery predicate = predicates[0];
        if (predicate.type() == IndexQuery.IndexQueryType.BOUNDING_BOX) {
            context.monitor().queried(this.descriptor);
            this.validateQuery(constraints, predicates);
            PropertyIndexQuery.BoundingBoxPredicate boundingBoxPredicate = (PropertyIndexQuery.BoundingBoxPredicate)predicate;
            try {
                BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
                client.initialize(this.descriptor, (IndexProgressor)multiProgressor, accessMode, false, false, constraints, new PropertyIndexQuery[]{boundingBoxPredicate});
                double[] from = boundingBoxPredicate.from().coordinate();
                double[] to = boundingBoxPredicate.to().coordinate();
                CoordinateReferenceSystem crs = boundingBoxPredicate.crs();
                SpaceFillingCurve curve = this.spaceFillingCurveSettings.forCrs(crs);
                List ranges = curve.getTilesIntersectingEnvelope(from, to, this.configuration);
                for (SpaceFillingCurve.LongRange range : ranges) {
                    PointKey treeKeyFrom = (PointKey)((Object)this.layout.newKey());
                    PointKey treeKeyTo = (PointKey)((Object)this.layout.newKey());
                    this.initializeFromToKeys(treeKeyFrom, treeKeyTo);
                    treeKeyFrom.writePointDerived(crs, range.min, NativeIndexKey.Inclusion.LOW);
                    treeKeyTo.writePointDerived(crs, range.max + 1L, NativeIndexKey.Inclusion.HIGH);
                    this.startSeekForInitializedRange((IndexProgressor.EntityValueClient)multiProgressor, treeKeyFrom, treeKeyTo, context.cursorContext(), accessMode, true, constraints, new PropertyIndexQuery[]{boundingBoxPredicate});
                }
            }
            catch (IllegalArgumentException e) {
                client.initialize(this.descriptor, IndexProgressor.EMPTY, accessMode, false, false, constraints, new PropertyIndexQuery[]{boundingBoxPredicate});
            }
        } else {
            super.query(client, context, accessMode, constraints, predicates);
        }
    }

    @Override
    boolean initializeRangeForQuery(PointKey treeKeyFrom, PointKey treeKeyTo, PropertyIndexQuery[] predicates) {
        PropertyIndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case ALL_ENTRIES: {
                treeKeyFrom.initValueAsLowest(-1, ValueGroup.GEOMETRY);
                treeKeyTo.initValueAsHighest(-1, ValueGroup.GEOMETRY);
                break;
            }
            case EXACT: {
                PropertyIndexQuery.ExactPredicate exactPredicate = (PropertyIndexQuery.ExactPredicate)predicate;
                treeKeyFrom.initFromValue(-1, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                treeKeyTo.initFromValue(-1, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                break;
            }
            default: {
                this.validateSupportedPredicates(predicate);
            }
        }
        return false;
    }
}

