/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public final class FileSizeThreshold
implements Threshold {
    private final FileSystemAbstraction fileSystem;
    private final long maxSize;
    private final InternalLog log;
    private long currentSize;

    FileSizeThreshold(FileSystemAbstraction fileSystem, long maxSize, InternalLogProvider logProvider) {
        this.fileSystem = fileSystem;
        this.maxSize = maxSize;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void init() {
        this.currentSize = 0L;
    }

    @Override
    public boolean reached(Path file, long version, LogFileInformation source) {
        try {
            this.currentSize += this.fileSystem.getFileSize(file);
        }
        catch (IOException e) {
            this.log.warn("Error on attempt to get file size from transaction log files. Checked version: " + version, (Throwable)e);
        }
        return this.currentSize >= this.maxSize;
    }

    public String toString() {
        return this.maxSize + " size";
    }
}

