/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.CommittedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.CommandBatchCursors;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public class PrefetchedReverseCommandBatchCursors
implements CommandBatchCursors {
    private final BlockingQueue<CommandBatchCursor> cursors = new LinkedBlockingDeque<CommandBatchCursor>(2);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final LogFile logFile;
    private final LogPosition beginning;
    private final LogEntryReader reader;
    private final boolean failOnCorruptedLogFiles;
    private final ReversedTransactionCursorMonitor monitor;
    private long currentVersion;

    public PrefetchedReverseCommandBatchCursors(LogFile logFile, LogPosition beginning, LogEntryReader reader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) {
        this.logFile = logFile;
        this.beginning = beginning;
        this.reader = reader;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.monitor = monitor;
        this.currentVersion = logFile.getHighestLogVersion();
        monitor.presketchingTransactionLogs();
        this.executor.execute(this::prepare);
    }

    @Override
    public Optional<CommandBatchCursor> next() {
        try {
            CommandBatchCursor cursor = this.cursors.take();
            if (cursor == NO_MORE_CURSORS) {
                return Optional.empty();
            }
            return Optional.of(cursor);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepare() {
        try {
            while (this.currentVersion >= this.beginning.getLogVersion()) {
                LogPosition position = this.currentVersion > this.beginning.getLogVersion() ? this.logFile.extractHeader(this.currentVersion).getStartPosition() : this.beginning;
                ReadableLogChannel channel = this.logFile.getReader(position, LogVersionBridge.NO_MORE_CHANNELS);
                if (channel instanceof ReadAheadLogChannel) {
                    this.cursors.put(new ReversedSingleFileCommandBatchCursor((ReadAheadLogChannel)channel, this.reader, this.failOnCorruptedLogFiles, this.monitor));
                } else {
                    this.cursors.put(EagerlyReversedCommandBatchCursor.eagerlyReverse(new CommittedCommandBatchCursor((ReadableLogPositionAwareChannel)channel, this.reader)));
                }
                --this.currentVersion;
            }
            this.cursors.put(NO_MORE_CURSORS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
    }
}

