/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.FileURIAccessRule;
import org.neo4j.kernel.impl.security.WebURLAccessRule;

public class URIAccessRules {
    public static final Set<String> WEB_SCHEMES = Set.of("http", "https", "ftp");
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final WebURLAccessRule webAccess;
    private final FileURIAccessRule fileAccess;

    public URIAccessRules(AbstractSecurityLog securityLog, Config configuration) {
        this(securityLog, new WebURLAccessRule((Configuration)configuration), new FileURIAccessRule(configuration));
    }

    public URIAccessRules(AbstractSecurityLog securityLog, WebURLAccessRule webAccess, FileURIAccessRule fileAccess) {
        this.securityAuthorizationHandler = new SecurityAuthorizationHandler(securityLog);
        this.webAccess = webAccess;
        this.fileAccess = fileAccess;
    }

    public WebURLAccessRule webAccess() {
        return this.webAccess;
    }

    public CharReadable validateAndOpen(SecurityContext securityContext, URI uri) throws URLAccessValidationError {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw LoadExternalResourceException.invalidUrlNoScheme((String)String.valueOf(uri));
        }
        try {
            if (WEB_SCHEMES.contains(scheme.toLowerCase(Locale.ROOT))) {
                return this.webAccess.getReader(uri.toURL(), this.securityAuthorizationHandler, securityContext);
            }
            return this.fileAccess.getReader(uri, this.securityAuthorizationHandler, securityContext);
        }
        catch (IOException e) {
            throw LoadExternalResourceException.couldNotLoadExternalResource((String)String.valueOf(uri), (Throwable)e);
        }
    }
}

