/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.nio.file.Path;
import java.util.function.Predicate;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public abstract class IndexFileFilter
implements Predicate<Path> {
    private final Path indexRoot;

    public IndexFileFilter(Path storeDir) {
        this.indexRoot = IndexDirectoryStructure.baseSchemaIndexFolder((Path)storeDir).toAbsolutePath();
    }

    public Path indexRoot() {
        return this.indexRoot;
    }

    protected Path schemaPath(Path path) {
        return this.indexRoot.relativize(path);
    }

    protected String provider(Path path) {
        return this.schemaPath(path).getName(0).toString();
    }

    @Override
    public boolean test(Path path) {
        return path.toAbsolutePath().startsWith(this.indexRoot) && this.schemaPath(path).getNameCount() != 0;
    }
}

