/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.EnvelopeSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class ConfiguredSpaceFillingCurveSettingsCache {
    private final Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();

    public ConfiguredSpaceFillingCurveSettingsCache(Config config) {
        Map<CoordinateReferenceSystem, EnvelopeSettings> env = EnvelopeSettings.envelopeSettingsFromConfig(config);
        for (Map.Entry<CoordinateReferenceSystem, EnvelopeSettings> entry : env.entrySet()) {
            CoordinateReferenceSystem crs = entry.getKey();
            this.settings.put(crs, SpaceFillingCurveSettingsFactory.fromConfig(entry.getValue()));
        }
    }

    public SpaceFillingCurveSettings forCRS(CoordinateReferenceSystem crs) {
        if (this.settings.containsKey(crs)) {
            return this.settings.get(crs);
        }
        return SpaceFillingCurveSettingsFactory.fromConfig(new EnvelopeSettings(crs));
    }
}

