/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeConstraintDefinition;

public class NodePropertyTypeConstraintDefinition
extends NodeConstraintDefinition {
    public NodePropertyTypeConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, Label label, String propertyKey) {
        super(actions, constraint, label, new String[]{propertyKey});
    }

    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.NODE_PROPERTY_TYPE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePropertyTypeConstraintDefinition that = (NodePropertyTypeConstraintDefinition)o;
        return this.label.name().equals(that.label.name()) && Arrays.equals(this.propertyKeys, that.propertyKeys) && this.constraint.asPropertyTypeConstraint().propertyType().equals((Object)that.constraint.asPropertyTypeConstraint().propertyType());
    }

    @Override
    public int hashCode() {
        int result = 31 * this.label.name().hashCode();
        result = 31 * result + Arrays.hashCode(this.propertyKeys);
        result = 31 * result + this.constraint.asPropertyTypeConstraint().propertyType().hashCode();
        return result;
    }

    @Override
    public String toString() {
        String labelName = NameUtil.escapeName((String)this.label.name());
        return String.format("FOR (%s:%s) REQUIRE %s IS :: %s", labelName.toLowerCase(), labelName, this.propertyText(labelName.toLowerCase()), this.constraint.asPropertyTypeConstraint().propertyType().userDescription());
    }

    @Override
    public PropertyType[] getPropertyType() {
        this.assertInUnterminatedTransaction();
        PropertyTypeSet propertyTypeSet = this.constraint.asPropertyTypeConstraint().propertyType();
        return (PropertyType[])propertyTypeSet.stream().map(SchemaValueType::toPublicApi).toArray(PropertyType[]::new);
    }
}

