/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import java.util.List;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

abstract class AbstractConstraintCreator {
    protected final InternalSchemaActions actions;
    protected final String name;
    protected final IndexType indexType;
    protected final IndexConfig indexConfig;

    AbstractConstraintCreator(InternalSchemaActions actions, String name, IndexType indexType, IndexConfig indexConfig) {
        this.actions = actions;
        this.name = name;
        this.indexType = indexType;
        this.indexConfig = indexConfig;
    }

    public ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("No constraint assertions specified");
    }

    protected final void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }

    protected PropertyTypeSet validatePropertyTypes(PropertyType[] propertyType) {
        List<SchemaValueType> internalTypes = Arrays.stream(propertyType).map(SchemaValueType::fromPublicApi).toList();
        PropertyTypeSet out = PropertyTypeSet.of(internalTypes);
        TypeRepresentation.validate((PropertyTypeSet)out);
        return out;
    }
}

