/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;

public class UnableToValidateConstraintException
extends ConstraintValidationException {
    public UnableToValidateConstraintException(ConstraintDescriptor constraint, Throwable cause, TokenNameLookup tokenNameLookup) {
        super(constraint, ConstraintValidationException.Phase.VERIFICATION, String.format("Unable to validate constraint %s", constraint.userDescription(tokenNameLookup)), cause, tokenNameLookup);
    }

    public UnableToValidateConstraintException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, Throwable cause, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, constraint, ConstraintValidationException.Phase.VERIFICATION, String.format("Unable to validate constraint %s", constraint.userDescription(tokenNameLookup)), cause, tokenNameLookup);
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Unable to validate constraint %s", this.constraint.userDescription(tokenNameLookup));
    }
}

