/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class AlreadyConstrainedException
extends SchemaKernelException {
    private static final String ALREADY_CONSTRAINED_MESSAGE_PREFIX = "Constraint already exists: ";
    private static final String INDEX_CONTEXT_FORMAT = "There is a uniqueness constraint on %s, so an index is already created that matches this.";
    private final ConstraintDescriptor constraint;
    private final SchemaKernelException.OperationContext context;

    public AlreadyConstrainedException(ConstraintDescriptor constraint, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super((Status)Status.Schema.ConstraintAlreadyExists, AlreadyConstrainedException.constructUserMessage(context, tokenNameLookup, constraint));
        this.constraint = constraint;
        this.context = context;
    }

    public AlreadyConstrainedException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintAlreadyExists, AlreadyConstrainedException.constructUserMessage(context, tokenNameLookup, constraint));
        this.constraint = constraint;
        this.context = context;
    }

    private static String constructUserMessage(SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, ConstraintDescriptor constraint) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case SchemaKernelException.OperationContext.INDEX_CREATION -> AlreadyConstrainedException.messageWithLabelAndPropertyName((TokenNameLookup)tokenNameLookup, (String)INDEX_CONTEXT_FORMAT, (SchemaDescriptor)constraint.schema());
            case SchemaKernelException.OperationContext.CONSTRAINT_CREATION -> ALREADY_CONSTRAINED_MESSAGE_PREFIX + constraint.userDescription(tokenNameLookup);
        };
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        if (this.constraint != null) {
            return AlreadyConstrainedException.constructUserMessage(this.context, tokenNameLookup, this.constraint);
        }
        return "Already constrained.";
    }
}

