/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.BaseRelationshipConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipKeyConstraintCreator;

public class RelationshipPropertyExistenceCreator
extends BaseRelationshipConstraintCreator {
    private final String propertyKey;

    RelationshipPropertyExistenceCreator(InternalSchemaActions actions, String name, RelationshipType type, String propertyKey, IndexType indexType, IndexConfig indexConfig) {
        super(actions, name, type, indexType, indexConfig);
        this.propertyKey = propertyKey;
    }

    @Override
    public ConstraintCreator assertPropertyExists(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one property existence constraint at a time.");
    }

    @Override
    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        if (this.propertyKey.equals(propertyKey)) {
            return new RelationshipKeyConstraintCreator(this.actions, this.name, this.type, List.of(propertyKey), this.indexType, this.indexConfig);
        }
        throw new UnsupportedOperationException("You cannot create a constraint on two different sets of property keys: [" + this.propertyKey + "] vs. [" + propertyKey + "].");
    }

    @Override
    public ConstraintCreator assertPropertyIsRelationshipKey(String propertyKey) {
        return this.assertPropertyIsUnique(propertyKey);
    }

    @Override
    public ConstraintCreator assertPropertyHasType(String propertyKey, PropertyType ... propertyType) {
        throw new UnsupportedOperationException("You cannot create a property type constraint together with other constraints.");
    }

    @Override
    public ConstraintDefinition create() {
        if (this.indexType != null) {
            throw new IllegalArgumentException("Relationship property existence constraints cannot be created with an index type. Was given index type " + String.valueOf(this.indexType) + ".");
        }
        if (this.indexConfig != null) {
            throw new IllegalArgumentException("Relationship property existence constraints cannot be created with an index configuration.");
        }
        return this.actions.createPropertyExistenceConstraint(this.name, this.type, this.propertyKey);
    }

    @Override
    public ConstraintCreator withName(String name) {
        return new RelationshipPropertyExistenceCreator(this.actions, name, this.type, this.propertyKey, this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexType(IndexType indexType) {
        return new RelationshipPropertyExistenceCreator(this.actions, this.name, this.type, this.propertyKey, indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new RelationshipPropertyExistenceCreator(this.actions, this.name, this.type, this.propertyKey, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }
}

