/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import org.neo4j.graphdb.TransactionRollbackException;
import org.neo4j.kernel.impl.api.chunk.ChunkedCommandBatch;
import org.neo4j.kernel.impl.api.chunk.ChunkedTransaction;
import org.neo4j.kernel.impl.api.chunk.TransactionRollbackProcess;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.tracing.RollbackBatchEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public final class MultiVersionTransactionRollbackProcess
implements TransactionRollbackProcess {
    private final LogicalTransactionStore transactionStore;
    private final StorageEngine storageEngine;

    public MultiVersionTransactionRollbackProcess(LogicalTransactionStore transactionStore, StorageEngine storageEngine) {
        this.transactionStore = transactionStore;
        this.storageEngine = storageEngine;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollbackChunks(ChunkedTransaction chunkedTransaction, TransactionRollbackEvent rollbackEvent) throws Exception {
        long transactionIdToRollback = chunkedTransaction.transactionId();
        long chunksToRollback = chunkedTransaction.chunkId() - 1L;
        int rolledbackBatches = 0;
        long nextBatchToRollbackIndex = chunkedTransaction.lastBatchAppendIndex();
        ChunkedTransaction rollbackChunkedTransaction = new ChunkedTransaction(transactionIdToRollback, chunkedTransaction.getTransactionSequenceNumber(), chunkedTransaction.cursorContext(), chunkedTransaction.storeCursors());
        try (RollbackBatchEvent rollbackDataEvent = rollbackEvent.beginRollbackDataEvent();){
            while ((long)rolledbackBatches != chunksToRollback) {
                MultiVersionTransactionRollbackProcess.validateBatchIndex(nextBatchToRollbackIndex, chunksToRollback, rolledbackBatches, transactionIdToRollback);
                CommandBatchCursor commandBatches = this.transactionStore.getCommandBatches(nextBatchToRollbackIndex);
                try {
                    if (!commandBatches.next()) {
                        throw new TransactionRollbackException(String.format("Transaction rollback failed. Expected to rollback %d batches, but was able to undo only %d for transaction with id %d.", chunksToRollback, rolledbackBatches, transactionIdToRollback));
                    }
                    CommittedCommandBatchRepresentation commandBatch = (CommittedCommandBatchRepresentation)commandBatches.get();
                    if (commandBatch.txId() != transactionIdToRollback) {
                        throw new TransactionRollbackException(String.format("Transaction rollback failed. Batch with transaction id %d encountered, while it was expected to belong to transaction id %d. Batch id: %s.", commandBatch.txId(), transactionIdToRollback, MultiVersionTransactionRollbackProcess.chunkId(commandBatch)));
                    }
                    rollbackChunkedTransaction.init((ChunkedCommandBatch)commandBatch.commandBatch());
                    this.storageEngine.apply((StorageEngineTransaction)rollbackChunkedTransaction, TransactionApplicationMode.MVCC_ROLLBACK);
                    ++rolledbackBatches;
                    nextBatchToRollbackIndex = commandBatch.previousBatchAppendIndex();
                }
                finally {
                    if (commandBatches == null) continue;
                    commandBatches.close();
                }
            }
            if (nextBatchToRollbackIndex != 0L) {
                throw new TransactionRollbackException(String.format("Transaction rollback failed. All expected %d batches in transaction id %d were rolled back but chain claims to have more at append index: %s.", chunksToRollback, transactionIdToRollback, nextBatchToRollbackIndex));
            }
            rollbackDataEvent.batchedRolledBack(chunksToRollback, transactionIdToRollback);
            return;
        }
    }

    private static void validateBatchIndex(long batchToRollbackIndex, long totalChunksToRollback, long rolledBackChunks, long transactionIdToRollback) {
        if (batchToRollbackIndex < 1L) {
            throw new TransactionRollbackException(String.format("Transaction rollback failed. Was able to rollback %d chunks out of %d for transaction %d until encountered incorrect batch index %d.", rolledBackChunks, totalChunksToRollback, transactionIdToRollback, batchToRollbackIndex));
        }
    }

    private static String chunkId(CommittedCommandBatchRepresentation commandBatch) {
        String string;
        CommandBatch commandBatch2 = commandBatch.commandBatch();
        if (commandBatch2 instanceof ChunkedCommandBatch) {
            ChunkedCommandBatch cc = (ChunkedCommandBatch)commandBatch2;
            string = String.valueOf(cc.chunkMetadata().chunkId());
        } else {
            string = "N/A";
        }
        return string;
    }
}

