/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class AlreadyIndexedException
extends SchemaKernelException {
    private static final String INDEX_CONTEXT_FORMAT = "There already exists an index %s.";
    private static final String CONSTRAINT_CONTEXT_FORMAT = "There already exists an index %s. A constraint cannot be created until the index has been dropped.";
    private final SchemaDescriptor descriptor;
    private final SchemaKernelException.OperationContext context;

    public AlreadyIndexedException(SchemaDescriptor descriptor, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super((Status)Status.Schema.IndexAlreadyExists, AlreadyIndexedException.constructUserMessage(context, tokenNameLookup, descriptor));
        this.descriptor = descriptor;
        this.context = context;
    }

    public AlreadyIndexedException(ErrorGqlStatusObject gqlStatusObject, SchemaDescriptor descriptor, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (Status)Status.Schema.IndexAlreadyExists, AlreadyIndexedException.constructUserMessage(context, tokenNameLookup, descriptor));
        this.descriptor = descriptor;
        this.context = context;
    }

    private static String constructUserMessage(SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, SchemaDescriptor descriptor) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case SchemaKernelException.OperationContext.INDEX_CREATION -> AlreadyIndexedException.messageWithLabelAndPropertyName((TokenNameLookup)tokenNameLookup, (String)INDEX_CONTEXT_FORMAT, (SchemaDescriptor)descriptor);
            case SchemaKernelException.OperationContext.CONSTRAINT_CREATION -> AlreadyIndexedException.messageWithLabelAndPropertyName((TokenNameLookup)tokenNameLookup, (String)CONSTRAINT_CONTEXT_FORMAT, (SchemaDescriptor)descriptor);
        };
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        if (this.descriptor != null) {
            return AlreadyIndexedException.constructUserMessage(this.context, tokenNameLookup, this.descriptor);
        }
        return "Already indexed.";
    }
}

