/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.MigrationStoreVersionCheck;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreFormatLimits;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;

public class AcrossEngineVersionCheck
implements MigrationStoreVersionCheck {
    private final StoreVersionCheck srcVersionCheck;
    private final StoreVersionCheck targetVersionCheck;
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final DatabaseLayout databaseLayout;
    private final Config config;
    private final LogService logService;
    private final StorageEngineFactory srcStorageEngineFactory;
    private final StorageEngineFactory targetStorageEngineFactory;

    public AcrossEngineVersionCheck(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, Config config, LogService logService, CursorContextFactory contextFactory, StorageEngineFactory srcStorageEngineFactory, StorageEngineFactory targetStorageEngineFactory) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.databaseLayout = databaseLayout;
        this.config = config;
        this.logService = logService;
        this.srcStorageEngineFactory = srcStorageEngineFactory;
        this.targetStorageEngineFactory = targetStorageEngineFactory;
        this.srcVersionCheck = srcStorageEngineFactory.versionCheck(fs, databaseLayout, config, pageCache, logService, contextFactory);
        this.targetVersionCheck = targetStorageEngineFactory.versionCheck(fs, databaseLayout, config, pageCache, logService, contextFactory);
    }

    public MigrationStoreVersionCheck.MigrationCheckResult getAndCheckMigrationTargetVersion(String formatToMigrateTo, CursorContext cursorContext) {
        StoreFormatLimits targetFormatLimits;
        StoreVersionIdentifier targetVersion;
        StoreVersionIdentifier currentVersion;
        try {
            currentVersion = this.srcVersionCheck.getCurrentVersion(cursorContext);
        }
        catch (Exception e) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.STORE_VERSION_RETRIEVAL_FAILURE, null, null, e);
        }
        try {
            targetVersion = this.targetVersionCheck.findLatestVersion(formatToMigrateTo);
        }
        catch (Exception e) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_TARGET_VERSION, currentVersion, null, e);
        }
        if (!this.targetVersionCheck.isStoreVersionFullySupported(targetVersion, cursorContext)) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_TARGET_VERSION, currentVersion, targetVersion, null);
        }
        Boolean includeFormatsUnderDevelopment = (Boolean)this.config.get(GraphDatabaseInternalSettings.include_versions_under_development);
        StoreFormatLimits srcFormatLimits = this.srcStorageEngineFactory.limitsForFormat(currentVersion.getFormatName(), includeFormatsUnderDevelopment.booleanValue());
        if (this.goingToLowerLimits(srcFormatLimits, targetFormatLimits = this.targetStorageEngineFactory.limitsForFormat(formatToMigrateTo, includeFormatsUnderDevelopment.booleanValue()))) {
            try {
                if (!this.srcStorageEngineFactory.fitsWithinStoreFormatLimits(targetFormatLimits, this.databaseLayout, this.fs, this.pageCache, this.config)) {
                    return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_MIGRATION_LIMITS, currentVersion, targetVersion, (Exception)new IllegalStateException("Migrating to a format with lower entity limits and the store has more entities than will fit within the limits. Switch to a different target format, or use neo4j-admin database copy to copy only relevant parts."));
                }
                this.logService.getUserLog(this.getClass()).info("Migrating to a format with lower entity limits. The store should fit into the target format, trying migration.");
            }
            catch (IOException | RuntimeException e) {
                return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_MIGRATION_LIMITS, currentVersion, targetVersion, e);
            }
        }
        return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.MIGRATION_POSSIBLE, currentVersion, targetVersion, null);
    }

    private boolean goingToLowerLimits(StoreFormatLimits fromLimits, StoreFormatLimits toLimits) {
        return fromLimits.maxLabelId() > toLimits.maxLabelId() || fromLimits.maxRelationshipTypeId() > toLimits.maxRelationshipTypeId() || fromLimits.maxPropertyKeyId() > toLimits.maxPropertyKeyId() || fromLimits.maxNodeId() > toLimits.maxNodeId() || fromLimits.maxRelationshipId() > toLimits.maxRelationshipId();
    }
}

