/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.kernel.impl.scheduler.FailedJobRunsStore;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.PooledJobHandle;
import org.neo4j.scheduler.FailedJobRun;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobType;
import org.neo4j.scheduler.MonitoredJobInfo;
import org.neo4j.scheduler.SchedulerThreadFactory;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.FeatureToggles;

final class ThreadPool {
    private static final int SHUTDOWN_TIMEOUT_SECONDS = FeatureToggles.getInteger(ThreadPool.class, (String)"shutdownTimeout", (int)30);
    private static final int UNMONITORED_JOB_ID = -1;
    private final SchedulerThreadFactory threadFactory;
    private final ExecutorService executor;
    private final ConcurrentHashMap<Object, RegisteredJob> registry;
    private final Group group;
    private final SystemNanoClock clock;
    private final FailedJobRunsStore failedJobRunsStore;
    private final LongSupplier jobIdSupplier;
    private InterruptedException shutdownInterrupted;

    ThreadPool(Group group, ThreadGroup parentThreadGroup, ThreadPoolParameters parameters, SystemNanoClock clock, FailedJobRunsStore failedJobRunsStore, LongSupplier jobIdSupplier) {
        this.group = group;
        this.clock = clock;
        this.failedJobRunsStore = failedJobRunsStore;
        this.jobIdSupplier = jobIdSupplier;
        this.threadFactory = parameters.providedThreadFactory.newSchedulerThreadFactory(group, parentThreadGroup);
        this.executor = group.buildExecutorService(this.threadFactory, parameters.desiredParallelism);
        this.registry = new ConcurrentHashMap();
    }

    ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public <T> JobHandle<T> submit(JobMonitoringParams jobMonitoringParams, Callable<T> job) {
        Object registryKey = new Object();
        AtomicBoolean running = new AtomicBoolean();
        Instant submitted = this.clock.instant();
        long jobId = JobMonitoringParams.NOT_MONITORED == jobMonitoringParams ? -1L : this.jobIdSupplier.getAsLong();
        Callable<Object> registeredJob = () -> {
            Instant executionStart = this.clock.instant();
            try {
                running.set(true);
                Object v = job.call();
                return v;
            }
            catch (Throwable t) {
                this.recordFailedRun(jobId, jobMonitoringParams, submitted, executionStart, t);
                throw t;
            }
            finally {
                this.registry.remove(registryKey);
            }
        };
        RegisteredJob placeHolder = new RegisteredJob(-1L, CompletableFuture.completedFuture(Void.TYPE), JobMonitoringParams.NOT_MONITORED, Instant.now(), new AtomicBoolean());
        this.registry.put(registryKey, placeHolder);
        try {
            Future<Object> future = this.executor.submit(registeredJob);
            this.registry.replace(registryKey, new RegisteredJob(jobId, future, jobMonitoringParams, submitted, running));
            return new PooledJobHandle<Object>(future, registryKey, this.registry);
        }
        catch (Exception e) {
            this.registry.remove(registryKey);
            throw e;
        }
    }

    public JobHandle<?> submit(JobMonitoringParams jobMonitoringParams, Runnable job) {
        return this.submit(jobMonitoringParams, ThreadPool.asCallable(job));
    }

    private static Callable<?> asCallable(Runnable job) {
        return () -> {
            job.run();
            return null;
        };
    }

    int activeJobCount() {
        return this.registry.size();
    }

    int activeThreadCount() {
        return this.threadFactory.getThreadGroup().activeCount();
    }

    Stream<Thread> activeThreads() {
        ThreadGroup threadGroup = this.threadFactory.getThreadGroup();
        int activeCountEstimate = threadGroup.activeCount();
        int activeCountFudge = Math.max((int)Math.sqrt(activeCountEstimate), 10);
        Thread[] snapshot = new Thread[activeCountEstimate + activeCountFudge];
        threadGroup.enumerate(snapshot);
        return Arrays.stream(snapshot).filter(Objects::nonNull);
    }

    void cancelAllJobs() {
        this.registry.values().removeIf(registeredJob -> {
            registeredJob.future.cancel(true);
            return true;
        });
    }

    void shutDown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(SHUTDOWN_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.shutdownInterrupted = e;
        }
    }

    List<MonitoredJobInfo> getMonitoredJobs() {
        return this.registry.values().stream().filter(registeredJob -> registeredJob.monitoredJobParams != JobMonitoringParams.NOT_MONITORED).map(monitoredJob -> new MonitoredJobInfo(monitoredJob.jobId, this.group, monitoredJob.submitted, monitoredJob.monitoredJobParams.getSubmitter(), monitoredJob.monitoredJobParams.getTargetDatabaseName(), monitoredJob.monitoredJobParams.getDescription(), null, null, monitoredJob.running.get() ? MonitoredJobInfo.State.EXECUTING : MonitoredJobInfo.State.SCHEDULED, JobType.IMMEDIATE, monitoredJob.monitoredJobParams.getCurrentStateDescription())).collect(Collectors.toList());
    }

    InterruptedException getShutdownException() {
        return this.shutdownInterrupted;
    }

    private void recordFailedRun(long jobId, JobMonitoringParams jobMonitoringParams, Instant submitted, Instant executionStart, Throwable t) {
        if (jobMonitoringParams == JobMonitoringParams.NOT_MONITORED) {
            return;
        }
        FailedJobRun failedJobRun = new FailedJobRun(jobId, this.group, jobMonitoringParams.getSubmitter(), jobMonitoringParams.getTargetDatabaseName(), jobMonitoringParams.getDescription(), JobType.IMMEDIATE, submitted, executionStart, this.clock.instant(), t);
        this.failedJobRunsStore.add(failedJobRun);
    }

    static class ThreadPoolParameters {
        volatile int desiredParallelism;
        volatile SchedulerThreadFactoryFactory providedThreadFactory = GroupedDaemonThreadFactory::new;

        ThreadPoolParameters() {
        }
    }

    private record RegisteredJob(long jobId, Future<?> future, JobMonitoringParams monitoredJobParams, Instant submitted, AtomicBoolean running) {
    }
}

