/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.stats;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.kernel.impl.monitoring.TransactionMonitor;
import org.neo4j.kernel.impl.monitoring.TransactionSizeMonitor;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;

public class DatabaseTransactionStats
implements TransactionMonitor,
TransactionCounters {
    private final AtomicLong activeReadTransactionCount = new AtomicLong();
    private final LongAdder startedTransactionCount = new LongAdder();
    private final LongAdder activeWriteTransactionCount = new LongAdder();
    private final LongAdder committedReadTransactionCount = new LongAdder();
    private final LongAdder committedWriteTransactionCount = new LongAdder();
    private final LongAdder rolledBackReadTransactionCount = new LongAdder();
    private final LongAdder rolledBackWriteTransactionCount = new LongAdder();
    private final LongAdder terminatedReadTransactionCount = new LongAdder();
    private final LongAdder terminatedWriteTransactionCount = new LongAdder();
    private final LongAdder totalTransactionsValidationFailures = new LongAdder();
    private final AtomicLong peakTransactionCount = new AtomicLong();
    private volatile TransactionSizeMonitor transactionSizeCallback = NullTransactionSizeCallback.INSTANCE;

    public void transactionStarted() {
        this.startedTransactionCount.increment();
        long active = this.activeReadTransactionCount.incrementAndGet();
        this.peakTransactionCount.updateAndGet(peak -> Math.max(peak, active));
    }

    public void transactionFinished(boolean committed, boolean write) {
        if (write) {
            this.activeWriteTransactionCount.decrement();
        } else {
            this.activeReadTransactionCount.decrementAndGet();
        }
        if (committed) {
            DatabaseTransactionStats.incrementCounter(this.committedReadTransactionCount, this.committedWriteTransactionCount, write);
        } else {
            DatabaseTransactionStats.incrementCounter(this.rolledBackReadTransactionCount, this.rolledBackWriteTransactionCount, write);
        }
    }

    public void transactionTerminated(boolean write) {
        DatabaseTransactionStats.incrementCounter(this.terminatedReadTransactionCount, this.terminatedWriteTransactionCount, write);
    }

    public void upgradeToWriteTransaction() {
        this.activeReadTransactionCount.decrementAndGet();
        this.activeWriteTransactionCount.increment();
    }

    public void transactionValidationFailure(DatabaseFile databaseFile) {
        this.totalTransactionsValidationFailures.increment();
    }

    @Override
    public long getPeakConcurrentNumberOfTransactions() {
        return this.peakTransactionCount.longValue();
    }

    @Override
    public long getNumberOfStartedTransactions() {
        return this.startedTransactionCount.longValue();
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.getNumberOfCommittedReadTransactions() + this.getNumberOfCommittedWriteTransactions();
    }

    @Override
    public long getNumberOfCommittedReadTransactions() {
        return this.committedReadTransactionCount.longValue();
    }

    @Override
    public long getNumberOfCommittedWriteTransactions() {
        return this.committedWriteTransactionCount.longValue();
    }

    @Override
    public long getNumberOfActiveTransactions() {
        return this.getNumberOfActiveReadTransactions() + this.getNumberOfActiveWriteTransactions();
    }

    @Override
    public long getNumberOfActiveReadTransactions() {
        return this.activeReadTransactionCount.longValue();
    }

    @Override
    public long getNumberOfActiveWriteTransactions() {
        return this.activeWriteTransactionCount.longValue();
    }

    @Override
    public long getNumberOfTerminatedTransactions() {
        return this.getNumberOfTerminatedReadTransactions() + this.getNumberOfTerminatedWriteTransactions();
    }

    @Override
    public long getNumberOfTerminatedReadTransactions() {
        return this.terminatedReadTransactionCount.longValue();
    }

    @Override
    public long getNumberOfTerminatedWriteTransactions() {
        return this.terminatedWriteTransactionCount.longValue();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.getNumberOfRolledBackReadTransactions() + this.getNumberOfRolledBackWriteTransactions();
    }

    @Override
    public long getNumberOfRolledBackReadTransactions() {
        return this.rolledBackReadTransactionCount.longValue();
    }

    @Override
    public long getNumberOfRolledBackWriteTransactions() {
        return this.rolledBackWriteTransactionCount.longValue();
    }

    @Override
    public long totalTransactionsValidationFailures() {
        return this.totalTransactionsValidationFailures.longValue();
    }

    @Override
    public void setTransactionSizeCallback(TransactionSizeMonitor transactionSizeMonitor) {
        this.transactionSizeCallback = transactionSizeMonitor != null ? transactionSizeMonitor : NullTransactionSizeCallback.INSTANCE;
    }

    public void addHeapTransactionSize(long transactionSizeHeap) {
        this.transactionSizeCallback.addHeapTransactionSize(transactionSizeHeap);
    }

    public void addNativeTransactionSize(long transactionSizeNative) {
        this.transactionSizeCallback.addNativeTransactionSize(transactionSizeNative);
    }

    private static void incrementCounter(LongAdder readCount, LongAdder writeCount, boolean write) {
        if (write) {
            writeCount.increment();
        } else {
            readCount.increment();
        }
    }

    private static class NullTransactionSizeCallback
    implements TransactionSizeMonitor {
        private static final TransactionSizeMonitor INSTANCE = new NullTransactionSizeCallback();

        private NullTransactionSizeCallback() {
        }

        public void addHeapTransactionSize(long transactionSizeHeap) {
        }

        public void addNativeTransactionSize(long transactionSizeNative) {
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public DatabaseTransactionStats create();
    }
}

