/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.common.Subject;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.chunk.ChunkMetadata;
import org.neo4j.kernel.impl.api.chunk.ChunkedCommandBatch;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.CommandBatch;

public record ChunkedRollbackBatchRepresentation(KernelVersion kernelVersion, long transactionId, long appendIndex, long timeWritten, int checksum) implements CommittedCommandBatchRepresentation
{
    @Override
    public CommandBatch commandBatch() {
        return new ChunkedCommandBatch(Collections.emptyList(), new ChunkMetadata(false, true, true, 0L, 0L, new MutableLong(-1L), new MutableLong(0L), this.timeWritten, -1L, this.timeWritten, -1, this.kernelVersion, Subject.ANONYMOUS));
    }

    @Override
    public int serialize(LogEntryWriter<? extends WritableChannel> writer) throws IOException {
        return writer.writeRollbackEntry(this.kernelVersion, this.transactionId, this.appendIndex, this.timeWritten);
    }

    @Override
    public long txId() {
        return this.transactionId;
    }

    @Override
    public boolean isRollback() {
        return true;
    }

    @Override
    public long previousBatchAppendIndex() {
        return 0L;
    }
}

