/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.kernel.impl.api.CommandCommitListeners;
import org.neo4j.kernel.impl.api.DatabaseTransactionCommitProcess;
import org.neo4j.kernel.impl.api.InternalTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionalProcessFactory;
import org.neo4j.kernel.impl.api.chunk.MultiVersionTransactionRollbackProcess;
import org.neo4j.kernel.impl.api.chunk.TransactionRollbackProcess;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.storageengine.api.StorageEngine;

public class DefaultTransactionalProcessFactory
implements TransactionalProcessFactory {
    @Override
    public TransactionCommitProcess create(TransactionAppender appender, StorageEngine storageEngine, DatabaseReadOnlyChecker readOnlyChecker, boolean preAllocateSpaceInStoreFiles, CommandCommitListeners commandCommitListeners) {
        return new DatabaseTransactionCommitProcess(new InternalTransactionCommitProcess(appender, storageEngine, preAllocateSpaceInStoreFiles, commandCommitListeners), readOnlyChecker);
    }

    @Override
    public TransactionRollbackProcess createRollbackProcess(StorageEngine storageEngine, LogicalTransactionStore transactionStore) {
        if (storageEngine.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED)) {
            return new MultiVersionTransactionRollbackProcess(transactionStore, storageEngine);
        }
        return TransactionRollbackProcess.EMPTY_ROLLBACK_PROCESS;
    }
}

