/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Map;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.AbstractResourceIterable;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenCapacityExceededKernelException;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.core.AbstractNodeEntity;
import org.neo4j.kernel.impl.coreapi.DefaultTransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.storable.Values;

public class NodeEntity
extends AbstractNodeEntity
implements RelationshipFactory<Relationship> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeEntity.class);
    private final InternalTransaction internalTransaction;
    private final long nodeId;

    public NodeEntity(InternalTransaction internalTransaction, long nodeId) {
        this.internalTransaction = internalTransaction;
        this.nodeId = nodeId;
    }

    public static boolean isDeletedInCurrentTransaction(Node node) {
        if (node instanceof NodeEntity) {
            NodeEntity proxy = (NodeEntity)node;
            KernelTransaction ktx = proxy.internalTransaction.kernelTransaction();
            return ktx.dataRead().nodeDeletedInTransaction(proxy.nodeId);
        }
        return false;
    }

    public long getId() {
        return this.nodeId;
    }

    public String getElementId() {
        return this.internalTransaction.elementIdMapper().nodeElementId(this.nodeId);
    }

    public void delete() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            boolean deleted = transaction.dataWrite().nodeDelete(this.getId());
            if (!deleted) {
                throw new NotFoundException("Unable to delete Node[" + this.nodeId + "] since it has already been deleted.");
            }
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.innerGetRelationships(transaction, direction, null);
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int[] typeIds = NodeEntity.relTypeIds(transaction.tokenRead(), types);
        return this.innerGetRelationships(transaction, direction, typeIds);
    }

    private ResourceIterable<Relationship> innerGetRelationships(KernelTransaction transaction, Direction direction, int[] typeIds) {
        return new RelationshipsIterable(transaction, this.getId(), direction, typeIds, this);
    }

    public boolean hasRelationship(Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.innerHasRelationships(transaction, direction, null);
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int[] typeIds = NodeEntity.relTypeIds(transaction.tokenRead(), types);
        return this.innerHasRelationships(transaction, direction, typeIds);
    }

    private boolean innerHasRelationships(KernelTransaction transaction, Direction direction, int[] typeIds) {
        try (ResourceIterator<Relationship> iterator = NodeEntity.getRelationshipSelectionIterator(transaction, this.getId(), direction, typeIds, this);){
            boolean bl = iterator.hasNext();
            return bl;
        }
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int[] typeIds = NodeEntity.relTypeIds(transaction.tokenRead(), type);
        try (ResourceIterator<Relationship> relationships = NodeEntity.getRelationshipSelectionIterator(transaction, this.getId(), dir, typeIds, this);){
            Relationship relationship = this.getSingleRelationship(relationships, type, dir);
            return relationship;
        }
    }

    public void setProperty(String key, Object value) {
        int propertyKeyId;
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (TokenCapacityExceededKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (KernelException e) {
            throw DefaultTransactionExceptionMapper.mapStatusException("Unknown error trying to create property key token", e.status(), (Exception)((Object)e));
        }
        try {
            transaction.dataWrite().nodeSetProperty(this.nodeId, propertyKeyId, Values.of((Object)value, (boolean)false));
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)transaction.tokenRead()), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            try {
                transaction.rollback();
            }
            catch (TransactionFailureException ex) {
                ex.addSuppressed((Throwable)e);
                ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_40N01).withClassification((GqlClassification)ErrorClassification.DATABASE_ERROR).build();
                throw new org.neo4j.graphdb.TransactionFailureException(gql, "Fail to rollback transaction.", (Throwable)ex, (Status)Status.Transaction.TransactionRollbackFailed);
            }
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Object removeProperty(String key) throws NotFoundException {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        int propertyKeyId = transaction.tokenRead().propertyKey(key);
        if (propertyKeyId == -1) {
            return Values.NO_VALUE.asObjectCopy();
        }
        try {
            return transaction.dataWrite().nodeRemoveProperty(this.nodeId, propertyKeyId).asObjectCopy();
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(nodes);
        return this.getProperty(key, defaultValue, (EntityCursor)nodes, transaction.ambientPropertyCursor());
    }

    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(nodes);
        return this.getPropertyKeys((EntityCursor)nodes, transaction.ambientPropertyCursor());
    }

    public Map<String, Object> getProperties(String ... keys) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(nodes);
        return this.getProperties((EntityCursor)transaction.ambientNodeCursor(), transaction.ambientPropertyCursor(), keys);
    }

    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(nodes);
        return this.getAllProperties((EntityCursor)transaction.ambientNodeCursor(), transaction.ambientPropertyCursor());
    }

    public Object getProperty(String key) throws NotFoundException {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(nodes);
        return this.getProperty(key, (EntityCursor)nodes, transaction.ambientPropertyCursor());
    }

    public boolean hasProperty(String key) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        this.singleNode(nodes);
        return this.hasProperty(key, (EntityCursor)nodes, transaction.ambientPropertyCursor());
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        int relationshipTypeId;
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            relationshipTypeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName(type.name());
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid type name '%s'.", type.name()), e);
        }
        catch (TokenCapacityExceededKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (KernelException e) {
            throw DefaultTransactionExceptionMapper.mapStatusException("Unknown error trying to create relationship type token", e.status(), (Exception)((Object)e));
        }
        try {
            long relationshipId = transaction.dataWrite().relationshipCreate(this.nodeId, relationshipTypeId, otherNode.getId());
            return this.internalTransaction.newRelationshipEntity(relationshipId, this.nodeId, relationshipTypeId, otherNode.getId());
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node[" + e.entityId() + "] is deleted and cannot be used to create a relationship");
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void addLabel(Label label) {
        int labelId;
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            labelId = transaction.tokenWrite().labelGetOrCreateForName(label.name());
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid label name '%s'.", label.name()), e);
        }
        catch (TokenCapacityExceededKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (KernelException e) {
            throw DefaultTransactionExceptionMapper.mapStatusException("Unknown error trying to create label token", e.status(), (Exception)((Object)e));
        }
        try {
            transaction.dataWrite().nodeAddLabel(this.getId(), labelId);
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)transaction.tokenRead()), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLabel(Label label) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        try {
            int labelId = transaction.tokenRead().nodeLabel(label.name());
            if (labelId != -1) {
                transaction.dataWrite().nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasLabel(Label label) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        return this.hasLabel(label, nodes);
    }

    public Iterable<Label> getLabels() {
        NodeCursor nodes = this.internalTransaction.kernelTransaction().ambientNodeCursor();
        return this.getLabels(nodes);
    }

    public InternalTransaction getTransaction() {
        return this.internalTransaction;
    }

    public int getDegree() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.getDegree(transaction.ambientNodeCursor());
    }

    public int getDegree(RelationshipType type) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.getDegree(type, transaction.ambientNodeCursor());
    }

    public int getDegree(Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.getDegree(direction, transaction.ambientNodeCursor());
    }

    public int getDegree(RelationshipType type, Direction direction) {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        return this.getDegree(type, direction, transaction.ambientNodeCursor());
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        KernelTransaction transaction = this.internalTransaction.kernelTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        return this.getRelationshipTypes(nodes);
    }

    @Override
    protected TokenRead tokenRead() {
        return this.internalTransaction.kernelTransaction().tokenRead();
    }

    @Override
    protected void singleNode(NodeCursor nodes) {
        this.singleNode(this.internalTransaction.kernelTransaction(), nodes);
    }

    private static ResourceIterator<Relationship> getRelationshipSelectionIterator(KernelTransaction transaction, long nodeId, Direction direction, int[] typeIds, RelationshipFactory<Relationship> factory) {
        NodeCursor node = transaction.ambientNodeCursor();
        transaction.dataRead().singleNode(nodeId, node);
        if (!node.next()) {
            throw new NotFoundException(String.format("Node %d not found", nodeId));
        }
        CursorContext cursorContext = transaction.cursorContext();
        CursorFactory cursors = transaction.cursors();
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.OUTGOING -> RelationshipSelections.outgoingIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, factory, (CursorContext)cursorContext);
            case Direction.INCOMING -> RelationshipSelections.incomingIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, factory, (CursorContext)cursorContext);
            case Direction.BOTH -> RelationshipSelections.allIterator((CursorFactory)cursors, (NodeCursor)node, (int[])typeIds, factory, (CursorContext)cursorContext);
        };
    }

    private void singleNode(KernelTransaction transaction, NodeCursor nodes) {
        transaction.dataRead().singleNode(this.nodeId, nodes);
        if (!nodes.next()) {
            throw new NotFoundException((Throwable)new EntityNotFoundException(EntityType.NODE, this.getElementId()));
        }
    }

    public Relationship relationship(RelationshipTraversalCursor cursor) {
        return this.internalTransaction.newRelationshipEntity((RelationshipDataAccessor)cursor);
    }

    private static class RelationshipsIterable
    extends AbstractResourceIterable<Relationship> {
        private final KernelTransaction transaction;
        private final long nodeId;
        private final Direction direction;
        private final int[] typeIds;
        private final RelationshipFactory<Relationship> factory;

        private RelationshipsIterable(KernelTransaction transaction, long nodeId, Direction direction, int[] typeIds, RelationshipFactory<Relationship> factory) {
            this.transaction = transaction;
            this.nodeId = nodeId;
            this.direction = direction;
            this.typeIds = typeIds;
            this.factory = factory;
        }

        protected ResourceIterator<Relationship> newIterator() {
            return NodeEntity.getRelationshipSelectionIterator(this.transaction, this.nodeId, this.direction, this.typeIds, this.factory);
        }
    }
}

