/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.CommandCommitListeners;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class InternalTransactionCommitProcess
implements TransactionCommitProcess {
    private final TransactionAppender appender;
    private final StorageEngine storageEngine;
    private final boolean preAllocateSpaceInStores;
    private final CommandCommitListeners commandCommitListeners;

    public InternalTransactionCommitProcess(TransactionAppender appender, StorageEngine storageEngine, boolean preAllocateSpaceInStores, CommandCommitListeners commandCommitListeners) {
        this.appender = appender;
        this.storageEngine = storageEngine;
        this.preAllocateSpaceInStores = preAllocateSpaceInStores;
        this.commandCommitListeners = commandCommitListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try {
            if (this.preAllocateSpaceInStores) {
                this.preAllocateSpaceInStores(batch, transactionWriteEvent, mode);
            }
            long lastAppendIndex = this.appendToLog(batch, transactionWriteEvent);
            try {
                this.applyToStore(batch, transactionWriteEvent, mode);
            }
            finally {
                InternalTransactionCommitProcess.close(batch);
            }
            this.commandCommitListeners.registerSuccess(batch.commandBatch(), lastAppendIndex);
            return lastAppendIndex;
        }
        catch (Exception e) {
            this.commandCommitListeners.registerFailure(batch.commandBatch(), e);
            throw e;
        }
    }

    private long appendToLog(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent) throws TransactionFailureException {
        LogAppendEvent logAppendEvent = transactionWriteEvent.beginLogAppend();
        try {
            long l = this.appender.append(batch, logAppendEvent);
            if (logAppendEvent != null) {
                logAppendEvent.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (logAppendEvent != null) {
                    try {
                        logAppendEvent.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable cause) {
                throw new TransactionFailureException((Status)Status.Transaction.TransactionLogError, cause, "Could not append transaction: " + batch + " to log.", new Object[0]);
            }
        }
    }

    protected void applyToStore(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try (StoreApplyEvent storeApplyEvent = transactionWriteEvent.beginStoreApply();){
            this.storageEngine.apply(batch, mode);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionCommitFailed, cause, "Could not apply the transaction: " + batch + " to the store after written to log.", new Object[0]);
        }
    }

    private void preAllocateSpaceInStores(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try {
            this.storageEngine.preAllocateStoreFilesForCommands(batch, mode);
        }
        catch (OutOfDiskSpaceException oods) {
            throw new TransactionFailureException((Status)Status.General.UnknownError, (Throwable)oods, "Could not preallocate disk space for the transaction: " + batch, new Object[0]);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionCommitFailed, cause, "Could not preallocate disk space for the transaction: " + batch, new Object[0]);
        }
    }

    private static void close(StorageEngineTransaction batch) {
        while (batch != null) {
            batch.close();
            batch = batch.next();
        }
    }
}

