/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.LabelCoexistenceConstraintDescriptor;

public final class LabelCoexistenceMissingLabelException
extends ConstraintValidationException {
    private final LabelCoexistenceConstraintDescriptor descriptor;
    private final long nodeReference;

    public LabelCoexistenceMissingLabelException(LabelCoexistenceConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long nodeReference, TokenNameLookup tokenNameLookup) {
        super((ConstraintDescriptor)descriptor, phase, String.format("Node(%d)", nodeReference), tokenNameLookup);
        this.descriptor = descriptor;
        this.nodeReference = nodeReference;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Node(%d) with label %s is required to have label %s", this.nodeReference, tokenNameLookup.labelGetName(this.descriptor.schema().getLabelId()), tokenNameLookup.labelGetName(this.descriptor.requiredLabelId()));
    }
}

