/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalLong;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogIndexEncoding;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.util.VisibleForTesting;

public class TransactionLogWriter {
    private final FlushableLogPositionAwareChannel channel;
    private final LogEntryWriter<FlushableLogPositionAwareChannel> writer;
    private final KernelVersionProvider versionProvider;
    private KernelVersion previousKernelVersion;
    private final LogRotation logRotation;
    private final LogPositionMarker logPositionMarker = new LogPositionMarker();

    public TransactionLogWriter(FlushableLogPositionAwareChannel channel, KernelVersionProvider versionProvider, BinarySupportedKernelVersions binarySupportedKernelVersions, LogRotation logRotation) {
        this(channel, new LogEntryWriter<FlushableLogPositionAwareChannel>(channel, binarySupportedKernelVersions), versionProvider, logRotation);
    }

    @VisibleForTesting
    public TransactionLogWriter(FlushableLogPositionAwareChannel channel, LogEntryWriter<FlushableLogPositionAwareChannel> writer, KernelVersionProvider versionProvider, LogRotation logRotation) {
        this.channel = channel;
        this.writer = writer;
        this.versionProvider = versionProvider;
        this.previousKernelVersion = versionProvider.kernelVersion();
        this.logRotation = logRotation;
    }

    public LogPosition beforeAppendPosition() {
        return this.logPositionMarker.newPosition();
    }

    public int append(CommandBatch batch, long transactionId, long chunkId, long appendIndex, int previousChecksum, long previousBatchAppendIndex, LogAppendEvent logAppendEvent) throws IOException {
        KernelVersion kernelVersion = batch.kernelVersion();
        if (kernelVersion == null) {
            kernelVersion = this.versionProvider.kernelVersion();
        }
        if (kernelVersion != this.previousKernelVersion) {
            assert (kernelVersion.isGreaterThan(this.previousKernelVersion));
            this.logRotation.locklessRotateLogFile(logAppendEvent, kernelVersion, appendIndex - 1L, previousChecksum);
            this.previousKernelVersion = kernelVersion;
        }
        this.channel.getCurrentLogPosition(this.logPositionMarker);
        if (batch.isRollback()) {
            return this.writer.writeRollbackEntry(kernelVersion, transactionId, appendIndex, batch.getTimeCommitted());
        }
        if (batch.isFirst()) {
            this.writer.writeStartEntry(kernelVersion, batch.getTimeStarted(), batch.getLatestCommittedTxWhenStarted(), appendIndex, previousChecksum, LogIndexEncoding.encodeLogIndex(batch.consensusIndex()));
        } else {
            this.writer.writeChunkStartEntry(kernelVersion, batch.getTimeCommitted(), chunkId, appendIndex, previousBatchAppendIndex);
        }
        this.writer.serialize((Iterable<StorageCommand>)batch, kernelVersion);
        if (batch.isLast()) {
            return this.writer.writeCommitEntry(kernelVersion, transactionId, batch.getTimeCommitted());
        }
        return this.writer.writeChunkEndEntry(kernelVersion, transactionId, chunkId);
    }

    public int append(CommittedCommandBatchRepresentation commandBatch) throws IOException {
        return commandBatch.serialize(this.writer);
    }

    public LogPosition getCurrentPosition() throws IOException {
        return this.channel.getCurrentLogPosition();
    }

    public void resetAppendedBytesCounter() {
        this.channel.resetAppendedBytesCounter();
    }

    public long getAppendedBytes() {
        return this.channel.getAppendedBytes();
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker logPositionMarker) throws IOException {
        return this.channel.getCurrentLogPosition(logPositionMarker);
    }

    @VisibleForTesting
    public FlushableLogPositionAwareChannel getChannel() {
        return this.channel;
    }

    public int append(ByteBuffer byteBuffer, LogAppendEvent logAppendEvent, OptionalLong appendIndex, Optional<Byte> kernelVersionByte, int checksum, long offset) throws IOException {
        if (appendIndex.isPresent()) {
            KernelVersion kernelVersion = kernelVersionByte.map(KernelVersion::getForVersion).orElse(this.previousKernelVersion);
            if (kernelVersion != this.previousKernelVersion) {
                this.logRotation.locklessRotateLogFile(logAppendEvent, kernelVersion, appendIndex.getAsLong() - 1L, checksum);
                this.previousKernelVersion = kernelVersion;
            } else {
                this.logRotation.locklessBatchedRotateLogIfNeeded(logAppendEvent, appendIndex.getAsLong() - 1L, kernelVersion, checksum);
            }
        }
        this.channel.getCurrentLogPosition(this.logPositionMarker);
        return this.channel.write(byteBuffer, offset);
    }

    @VisibleForTesting
    public LogEntryWriter<FlushableLogPositionAwareChannel> getWriter() {
        return this.writer;
    }
}

