/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.memory.MemoryTracker;

public final class ReadAheadUtils {
    private ReadAheadUtils() {
    }

    public static ReadableLogChannel newChannel(LogVersionedStoreChannel channel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        return ReadAheadUtils.newChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, logHeader, memoryTracker, false);
    }

    public static ReadableLogChannel newChannel(LogVersionedStoreChannel channel, LogVersionBridge logVersionBridge, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        return ReadAheadUtils.newChannel(channel, logVersionBridge, logHeader, memoryTracker, false);
    }

    public static ReadableLogChannel newChannel(LogVersionedStoreChannel channel, LogVersionBridge logVersionBridge, LogHeader logHeader, MemoryTracker memoryTracker, boolean raw) throws IOException {
        LogFormat formatVersion = channel.getLogFormatVersion();
        if (formatVersion.usesSegments()) {
            return new EnvelopeReadChannel(channel, logHeader.getSegmentBlockSize(), logVersionBridge, memoryTracker, raw);
        }
        return new ReadAheadLogChannel(channel, logVersionBridge, memoryTracker, raw);
    }

    public static ReadableLogChannel newChannel(LogFile logFile, long version, MemoryTracker memoryTracker) throws IOException {
        return ReadAheadUtils.newChannel(logFile, version, LogVersionBridge.NO_MORE_CHANNELS, memoryTracker);
    }

    public static ReadableLogChannel newChannel(LogFile logFile, long version, LogVersionBridge logVersionBridge, MemoryTracker memoryTracker) throws IOException {
        PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(version);
        LogFormat formatVersion = channel.getLogFormatVersion();
        if (formatVersion.usesSegments()) {
            LogHeader logHeader = logFile.extractHeader(version);
            return ReadAheadUtils.newChannel(channel, logVersionBridge, logHeader, memoryTracker);
        }
        return new ReadAheadLogChannel((LogVersionedStoreChannel)channel, logVersionBridge, memoryTracker, false);
    }
}

