/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.impl.transaction.log.AppendedChunkLogVersionLocator;
import org.neo4j.kernel.impl.transaction.log.AppendedChunkPositionLocator;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchLogEntryException;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.reverse.ForwardCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedMultiFileCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class PhysicalLogicalTransactionStore
implements LogicalTransactionStore {
    private final LogFile logFile;
    private final TransactionMetadataCache transactionMetadataCache;
    private final CommandReaderFactory commandReaderFactory;
    private final Monitors monitors;
    private final boolean failOnCorruptedLogFiles;
    private final boolean presketchLogFiles;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final FileSystemAbstraction fs;

    public PhysicalLogicalTransactionStore(LogFiles logFiles, TransactionMetadataCache transactionMetadataCache, CommandReaderFactory commandReaderFactory, Monitors monitors, boolean failOnCorruptedLogFiles, Config config, FileSystemAbstraction fs) {
        this.logFile = logFiles.getLogFile();
        this.transactionMetadataCache = transactionMetadataCache;
        this.commandReaderFactory = commandReaderFactory;
        this.monitors = monitors;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.presketchLogFiles = (Boolean)config.get(GraphDatabaseInternalSettings.pre_sketch_transaction_logs);
        this.binarySupportedKernelVersions = new BinarySupportedKernelVersions(config);
        this.fs = fs;
    }

    @Override
    public CommandBatchCursor getCommandBatches(LogPosition position) throws IOException {
        return new ForwardCommandBatchCursor(this.logFile, position, (LogEntryReader)new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions), this.fs);
    }

    @Override
    public CommandBatchCursor getCommandBatchesInReverseOrder(LogPosition backToPosition) {
        return ReversedMultiFileCommandBatchCursor.fromLogFile(this.logFile, backToPosition, (LogEntryReader)new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions), this.failOnCorruptedLogFiles, (ReversedTransactionCursorMonitor)this.monitors.newMonitor(ReversedTransactionCursorMonitor.class, new String[0]), this.presketchLogFiles);
    }

    @Override
    public CommandBatchCursor getCommandBatches(long appendIndexToStartFrom) throws IOException {
        try {
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions);
            TransactionMetadataCache.TransactionMetadata transactionMetadata = this.transactionMetadataCache.getTransactionMetadata(appendIndexToStartFrom);
            if (transactionMetadata != null) {
                return new ForwardCommandBatchCursor(this.logFile, transactionMetadata.startPosition(), (LogEntryReader)logEntryReader, this.fs);
            }
            AppendedChunkLogVersionLocator headerVisitor = new AppendedChunkLogVersionLocator(appendIndexToStartFrom);
            this.logFile.accept(headerVisitor);
            AppendedChunkPositionLocator transactionPositionLocator = new AppendedChunkPositionLocator(appendIndexToStartFrom, (LogEntryReader)logEntryReader);
            this.logFile.accept(transactionPositionLocator, headerVisitor.getLogPositionOrThrow());
            LogPosition position = transactionPositionLocator.getLogPositionOrThrow();
            this.transactionMetadataCache.cacheTransactionMetadata(appendIndexToStartFrom, position);
            return new ForwardCommandBatchCursor(this.logFile, position, (LogEntryReader)logEntryReader, this.fs);
        }
        catch (NoSuchFileException e) {
            throw new NoSuchLogEntryException(appendIndexToStartFrom, "Log position acquired, but couldn't find the log file itself. Perhaps it just recently was deleted? [" + e.getMessage() + "]", e);
        }
    }
}

