/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.graphdb.Resource;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.TokenIndexIdLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;

public class TokenScanValueIndexProgressor
implements IndexProgressor,
Resource {
    public static final int RANGE_SIZE = 64;
    private final Seeker<TokenScanKey, TokenScanValue> cursor;
    private long baseEntityId;
    private long bits;
    private int prevToken = -1;
    private long prevRange = -1L;
    private boolean closed;
    private final IndexProgressor.EntityTokenClient client;
    private final IndexOrder indexOrder;
    private final EntityRange range;
    private final TokenIndexIdLayout idLayout;
    private final int tokenId;

    TokenScanValueIndexProgressor(Seeker<TokenScanKey, TokenScanValue> cursor, IndexProgressor.EntityTokenClient client, IndexOrder indexOrder, EntityRange range, TokenIndexIdLayout idLayout, int tokenId) {
        this.cursor = cursor;
        this.client = client;
        this.indexOrder = indexOrder;
        this.range = range;
        this.idLayout = idLayout;
        this.tokenId = tokenId;
    }

    public boolean next() {
        while (true) {
            if (this.bits != 0L) {
                long idForClient;
                if (!this.isInRange(idForClient = (switch (this.indexOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case IndexOrder.DESCENDING -> this.extractNextId(64 - Long.numberOfLeadingZeros(this.bits) - 1);
                    case IndexOrder.ASCENDING, IndexOrder.NONE -> this.extractNextId(Long.numberOfTrailingZeros(this.bits));
                })) || !this.client.acceptEntity(idForClient, this.tokenId)) continue;
                return true;
            }
            if (!this.nextRange()) {
                return false;
            }
            if (!$assertionsDisabled && !this.keysInOrder((TokenScanKey)this.cursor.key(), this.indexOrder)) break;
        }
        throw new AssertionError();
    }

    private long extractNextId(int relevantBitPos) {
        long bitToFlip = 1L << relevantBitPos;
        assert ((this.bits & bitToFlip) != 0L);
        this.bits -= bitToFlip;
        return this.baseEntityId + (long)relevantBitPos;
    }

    private boolean nextRange() {
        try {
            if (!this.cursor.next()) {
                this.close();
                return false;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        TokenScanKey key = (TokenScanKey)this.cursor.key();
        this.baseEntityId = this.idLayout.firstIdOfRange(key.idRange);
        this.bits = ((TokenScanValue)this.cursor.value()).bits;
        assert (key.tokenId == this.tokenId);
        return true;
    }

    public void skipUntil(long id) {
        if (id - this.baseEntityId > 640L) {
            if (this.indexOrder != IndexOrder.DESCENDING) {
                this.cursor.reinitializeToNewRange((Object)new TokenScanKey(this.tokenId, this.idLayout.rangeOf(id)), (Object)new TokenScanKey(this.tokenId, Long.MAX_VALUE));
            } else {
                this.cursor.reinitializeToNewRange((Object)new TokenScanKey(this.tokenId, this.idLayout.rangeOf(id)), (Object)new TokenScanKey(this.tokenId, Long.MIN_VALUE));
            }
            if (!this.nextRange()) {
                return;
            }
        } else if (this.bits == 0L && !this.nextRange()) {
            return;
        }
        while (!this.isAtOrPastBitMapRange(id)) {
            if (this.nextRange()) continue;
            this.bits = 0L;
            return;
        }
        if (!this.isInBitMapRange(id)) {
            return;
        }
        long offset = this.idLayout.idWithinRange(id);
        this.bits = this.indexOrder != IndexOrder.DESCENDING ? (this.bits &= -1L << (int)offset) : (this.bits &= -1L >>> (int)(64L - offset - 1L));
    }

    private boolean isInBitMapRange(long id) {
        return this.idLayout.rangeOf(id) == this.idLayout.rangeOf(this.baseEntityId);
    }

    private boolean isAtOrPastBitMapRange(long id) {
        if (this.indexOrder != IndexOrder.DESCENDING) {
            return this.idLayout.rangeOf(id) <= this.idLayout.rangeOf(this.baseEntityId);
        }
        return this.idLayout.rangeOf(id) >= this.idLayout.rangeOf(this.baseEntityId);
    }

    private boolean isInRange(long entityId) {
        return this.range.contains(entityId);
    }

    private boolean keysInOrder(TokenScanKey key, IndexOrder order) {
        if (order == IndexOrder.NONE) {
            return true;
        }
        if (this.prevToken != -1 && this.prevRange != -1L && order == IndexOrder.ASCENDING) {
            assert (key.tokenId >= this.prevToken) : "Expected to get ascending ordered results, got " + key + " where previous token was " + this.prevToken;
            assert (key.idRange > this.prevRange) : "Expected to get ascending ordered results, got " + key + " where previous range was " + this.prevRange;
        } else if (this.prevToken != -1 && this.prevRange != -1L && order == IndexOrder.DESCENDING) {
            assert (key.tokenId <= this.prevToken) : "Expected to get descending ordered results, got " + key + " where previous token was " + this.prevToken;
            assert (key.idRange < this.prevRange) : "Expected to get descending ordered results, got " + key + " where previous range was " + this.prevRange;
        }
        this.prevToken = key.tokenId;
        this.prevRange = key.idRange;
        return true;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.cursor.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

