/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.commit;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.TransactionRollbackException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.chunk.ChunkMetadata;
import org.neo4j.kernel.impl.api.chunk.ChunkedCommandBatch;
import org.neo4j.kernel.impl.api.chunk.ChunkedTransaction;
import org.neo4j.kernel.impl.api.chunk.TransactionRollbackProcess;
import org.neo4j.kernel.impl.api.commit.TransactionCommitter;
import org.neo4j.kernel.impl.api.transaction.serial.SerialExecutionGuard;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.validation.TransactionConflictException;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;
import org.neo4j.storageengine.api.txstate.validation.ValidationLockDumper;

public final class ChunkCommitter
implements TransactionCommitter {
    private final KernelTransactionImplementation ktx;
    private int chunkNumber = 1;
    private long previousBatchAppendIndex = 0L;
    private KernelVersion kernelVersion;
    private ChunkedTransaction transactionPayload;
    private final TransactionCommitmentFactory commitmentFactory;
    private final KernelVersionProvider kernelVersionProvider;
    private final StoreCursors transactionalCursors;
    private final TransactionIdGenerator transactionIdGenerator;
    private final TransactionCommitProcess commitProcess;
    private final DatabaseHealth databaseHealth;
    private final TransactionClockContext clocks;
    private final TransactionRollbackProcess chunkedRollbackProcess;
    private final TransactionValidator transactionValidator;
    private final ValidationLockDumper validationLockDumper;
    private final SerialExecutionGuard serialExecutionGuard;
    private final Log log;
    private final TopologyGraphDbmsModel.HostedOnMode mode;
    private long lastTransactionIdWhenStarted;
    private long startTimeMillis;
    private LeaseClient leaseClient;

    public ChunkCommitter(KernelTransactionImplementation ktx, TransactionCommitmentFactory commitmentFactory, KernelVersionProvider kernelVersionProvider, StoreCursors transactionalCursors, TransactionIdGenerator transactionIdGenerator, TransactionCommitProcess commitProcess, DatabaseHealth databaseHealth, TransactionClockContext clocks, TransactionRollbackProcess chunkedRollbackProcess, TransactionValidator transactionValidator, ValidationLockDumper validationLockDumper, SerialExecutionGuard serialExecutionGuard, LogProvider logProvider, TopologyGraphDbmsModel.HostedOnMode mode) {
        this.ktx = ktx;
        this.commitmentFactory = commitmentFactory;
        this.kernelVersionProvider = kernelVersionProvider;
        this.transactionalCursors = transactionalCursors;
        this.transactionIdGenerator = transactionIdGenerator;
        this.commitProcess = commitProcess;
        this.databaseHealth = databaseHealth;
        this.clocks = clocks;
        this.chunkedRollbackProcess = chunkedRollbackProcess;
        this.transactionValidator = transactionValidator;
        this.validationLockDumper = validationLockDumper;
        this.serialExecutionGuard = serialExecutionGuard;
        this.log = logProvider.getLog(ChunkCommitter.class);
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit(TransactionWriteEvent transactionWriteEvent, LeaseClient leaseClient, CursorContext cursorContext, MemoryTracker memoryTracker, KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor, LockTracer lockTracer, long commitTime, long startTimeMillis, long lastTransactionIdWhenStarted, boolean commit, TransactionApplicationMode mode) throws KernelException {
        LockManager.Client lockClient = this.ktx.lockClient();
        try {
            List<StorageCommand> extractedCommands = this.ktx.extractCommands(memoryTracker);
            if (!extractedCommands.isEmpty() || commit && this.transactionPayload != null) {
                this.serialExecutionGuard.check();
                if (this.kernelVersion == null) {
                    this.kernelVersion = this.kernelVersionProvider.kernelVersion();
                    this.lastTransactionIdWhenStarted = lastTransactionIdWhenStarted;
                    this.startTimeMillis = lastTransactionIdWhenStarted;
                    this.leaseClient = leaseClient;
                }
                if (commit) {
                    this.validateCurrentKernelVersion();
                }
                try {
                    this.transactionValidator.validate(extractedCommands, cursorContext, lockClient, lockTracer, this.validationLockDumper);
                    ChunkMetadata chunkMetadata = new ChunkMetadata(this.chunkNumber == 1, commit, false, this.previousBatchAppendIndex, this.chunkNumber, new MutableLong(-1L), new MutableLong(0L), startTimeMillis, lastTransactionIdWhenStarted, commitTime, leaseClient.leaseId(), this.kernelVersion, this.ktx.securityContext().subject().userSubject());
                    ChunkedTransaction transaction = this.getTransaction(cursorContext);
                    ChunkedCommandBatch chunk = new ChunkedCommandBatch(extractedCommands, chunkMetadata);
                    transaction.init(chunk);
                    long appendIndex = this.commitProcess.commit(transaction, transactionWriteEvent, mode);
                    this.transactionPayload = transaction;
                    this.transactionPayload.updateClusteredTransactionId(appendIndex);
                    this.validationLockDumper.dumpLocks(this.transactionValidator, lockClient, this.chunkNumber, this.transactionPayload.transactionId());
                    transactionWriteEvent.chunkAppended(this.chunkNumber, this.ktx.getTransactionSequenceNumber(), this.transactionPayload.transactionId());
                }
                catch (TransactionConflictException tce) {
                    throw tce;
                }
                catch (Exception e) {
                    this.log.debug("Transaction chunk commit failure.", (Throwable)e);
                    throw e;
                }
                this.previousBatchAppendIndex = this.transactionPayload.lastBatchAppendIndex();
                ++this.chunkNumber;
            }
            long l = this.transactionPayload != null ? this.transactionPayload.transactionId() : 0L;
            return l;
        }
        finally {
            lockClient.reset();
        }
    }

    @Override
    public void rollback(TransactionRollbackEvent rollbackEvent) {
        if (this.transactionPayload != null) {
            try {
                this.validateCurrentKernelVersion();
                this.prepareRollBackEntry();
                if (this.isSingleInstance()) {
                    this.chunkedRollbackProcess.rollbackChunks(this.transactionPayload, rollbackEvent);
                }
                this.writeRollbackEntry(rollbackEvent);
            }
            catch (Exception e) {
                if (this.isSingleInstance()) {
                    this.databaseHealth.panic((Throwable)e);
                }
                Exceptions.throwIfInstanceOf((Throwable)e, TransactionRollbackException.class);
                throw new TransactionRollbackException("Transaction rollback failed", (Throwable)e);
            }
        }
    }

    private boolean isSingleInstance() {
        return TopologyGraphDbmsModel.HostedOnMode.SINGLE == this.mode;
    }

    private ChunkedTransaction getTransaction(CursorContext cursorContext) {
        return this.transactionPayload != null ? this.transactionPayload : new ChunkedTransaction(cursorContext, this.ktx.getTransactionSequenceNumber(), this.transactionalCursors, this.commitmentFactory.newCommitment(), this.transactionIdGenerator);
    }

    private void writeRollbackEntry(TransactionRollbackEvent transactionRollbackEvent) throws TransactionFailureException {
        try (TransactionWriteEvent writeEvent = transactionRollbackEvent.beginRollbackWriteEvent();){
            this.commitProcess.commit(this.transactionPayload, writeEvent, TransactionApplicationMode.INTERNAL);
        }
    }

    private void prepareRollBackEntry() {
        ChunkMetadata chunkMetadata = new ChunkMetadata(false, true, true, 0L, this.chunkNumber, new MutableLong(-1L), new MutableLong(0L), this.startTimeMillis, this.lastTransactionIdWhenStarted, this.clocks.systemClock().millis(), this.leaseClient.leaseId(), this.kernelVersion, this.ktx.securityContext().subject().userSubject());
        ChunkedCommandBatch chunk = new ChunkedCommandBatch(Collections.emptyList(), chunkMetadata);
        this.transactionPayload.init(chunk);
    }

    private void validateCurrentKernelVersion() {
        if (this.kernelVersion != this.kernelVersionProvider.kernelVersion()) {
            throw new UnsupportedOperationException("We do not support upgrade during chunked transaction.");
        }
    }

    @Override
    public void reset() {
        this.chunkNumber = 1;
        this.kernelVersion = null;
        this.transactionPayload = null;
        this.lastTransactionIdWhenStarted = 0L;
        this.startTimeMillis = 0L;
        this.leaseClient = null;
    }
}

