/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.api.CompleteTransaction;

public class TransactionQueue {
    private final int maxSize;
    private final Applier applier;
    private CompleteTransaction tail;
    private CompleteTransaction head;
    private int size;

    public TransactionQueue(int maxSize, Applier applier) {
        this.maxSize = maxSize;
        this.applier = applier;
    }

    public void queue(CompleteTransaction transaction) throws Exception {
        if (this.isNotEmpty()) {
            this.tail.next(transaction);
        } else {
            this.head = transaction;
        }
        this.tail = transaction;
        if (++this.size == this.maxSize) {
            this.applyTransactions();
        }
    }

    public void applyTransactions() throws Exception {
        if (this.isNotEmpty()) {
            this.applier.apply(this.head);
            this.tail = null;
            this.head = null;
            this.size = 0;
        }
    }

    private boolean isNotEmpty() {
        return this.size != 0;
    }

    @FunctionalInterface
    public static interface Applier {
        public void apply(CompleteTransaction var1) throws Exception;
    }
}

