/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class ConflictingConstraintException
extends SchemaKernelException {
    private static final String CONFLICTING_CONSTRAINT_PREFIX = "Conflicting constraint already exists: ";

    public ConflictingConstraintException(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup) {
        super((Status)Status.Schema.ConstraintAlreadyExists, ConflictingConstraintException.constructUserMessage(tokenNameLookup, constraint));
    }

    public ConflictingConstraintException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintAlreadyExists, ConflictingConstraintException.constructUserMessage(tokenNameLookup, constraint));
    }

    private static String constructUserMessage(TokenNameLookup tokenNameLookup, ConstraintDescriptor constraint) {
        return CONFLICTING_CONSTRAINT_PREFIX + constraint.userDescription(tokenNameLookup);
    }
}

